package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceArn,
  ReadSetName,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReadSetFilter(
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    name: Optional[ReadSetName] = Optional.Absent,
    referenceArn: Optional[ReferenceArn] = Optional.Absent,
    status: Optional[zio.aws.omics.model.ReadSetStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReadSetFilter = {
    import ReadSetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReadSetFilter
      .builder()
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .optionallyWith(
        name.map(value => ReadSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReadSetFilter.ReadOnly =
    zio.aws.omics.model.ReadSetFilter.wrap(buildAwsValue())
}
object ReadSetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReadSetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReadSetFilter =
      zio.aws.omics.model.ReadSetFilter(
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        name.map(value => value),
        referenceArn.map(value => value),
        status.map(value => value)
      )
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def name: Optional[ReadSetName]
    def referenceArn: Optional[ReferenceArn]
    def status: Optional[zio.aws.omics.model.ReadSetStatus]
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getName: ZIO[Any, AwsError, ReadSetName] =
      AwsError.unwrapOptionField("name", name)
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.ReadSetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReadSetFilter
  ) extends zio.aws.omics.model.ReadSetFilter.ReadOnly {
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val name: Optional[ReadSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReadSetName(value))
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
    override val status: Optional[zio.aws.omics.model.ReadSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.ReadSetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReadSetFilter
  ): zio.aws.omics.model.ReadSetFilter.ReadOnly = new Wrapper(impl)
}
