package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait ReadSetStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.ReadSetStatus
}
object ReadSetStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.ReadSetStatus
  ): zio.aws.omics.model.ReadSetStatus = value match {
    case software.amazon.awssdk.services.omics.model.ReadSetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.ReadSetStatus.ARCHIVED =>
      val r = ARCHIVED
      r
    case software.amazon.awssdk.services.omics.model.ReadSetStatus.ACTIVATING =>
      val r = ACTIVATING
      r
    case software.amazon.awssdk.services.omics.model.ReadSetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.omics.model.ReadSetStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.omics.model.ReadSetStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.ReadSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetStatus =
      software.amazon.awssdk.services.omics.model.ReadSetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ARCHIVED extends zio.aws.omics.model.ReadSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetStatus =
      software.amazon.awssdk.services.omics.model.ReadSetStatus.ARCHIVED
  }
  case object ACTIVATING extends zio.aws.omics.model.ReadSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetStatus =
      software.amazon.awssdk.services.omics.model.ReadSetStatus.ACTIVATING
  }
  case object ACTIVE extends zio.aws.omics.model.ReadSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetStatus =
      software.amazon.awssdk.services.omics.model.ReadSetStatus.ACTIVE
  }
  case object DELETING extends zio.aws.omics.model.ReadSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetStatus =
      software.amazon.awssdk.services.omics.model.ReadSetStatus.DELETING
  }
  case object DELETED extends zio.aws.omics.model.ReadSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReadSetStatus =
      software.amazon.awssdk.services.omics.model.ReadSetStatus.DELETED
  }
}
