package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait ReferenceFile {
  def unwrap: software.amazon.awssdk.services.omics.model.ReferenceFile
}
object ReferenceFile {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.ReferenceFile
  ): zio.aws.omics.model.ReferenceFile = value match {
    case software.amazon.awssdk.services.omics.model.ReferenceFile.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.ReferenceFile.SOURCE =>
      val r = SOURCE
      r
    case software.amazon.awssdk.services.omics.model.ReferenceFile.INDEX =>
      val r = INDEX
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.ReferenceFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceFile =
      software.amazon.awssdk.services.omics.model.ReferenceFile.UNKNOWN_TO_SDK_VERSION
  }
  case object SOURCE extends zio.aws.omics.model.ReferenceFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceFile =
      software.amazon.awssdk.services.omics.model.ReferenceFile.SOURCE
  }
  case object INDEX extends zio.aws.omics.model.ReferenceFile {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceFile =
      software.amazon.awssdk.services.omics.model.ReferenceFile.INDEX
  }
}
