package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceName,
  Md5,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReferenceFilter(
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    md5: Optional[Md5] = Optional.Absent,
    name: Optional[ReferenceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReferenceFilter = {
    import ReferenceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReferenceFilter
      .builder()
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .optionallyWith(md5.map(value => Md5.unwrap(value): java.lang.String))(
        _.md5
      )
      .optionallyWith(
        name.map(value => ReferenceName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReferenceFilter.ReadOnly =
    zio.aws.omics.model.ReferenceFilter.wrap(buildAwsValue())
}
object ReferenceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReferenceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReferenceFilter =
      zio.aws.omics.model.ReferenceFilter(
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        md5.map(value => value),
        name.map(value => value)
      )
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def md5: Optional[Md5]
    def name: Optional[ReferenceName]
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getMd5: ZIO[Any, AwsError, Md5] = AwsError.unwrapOptionField("md5", md5)
    def getName: ZIO[Any, AwsError, ReferenceName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReferenceFilter
  ) extends zio.aws.omics.model.ReferenceFilter.ReadOnly {
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val md5: Optional[Md5] = zio.aws.core.internal
      .optionalFromNullable(impl.md5())
      .map(value => zio.aws.omics.model.primitives.Md5(value))
    override val name: Optional[ReferenceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReferenceFilter
  ): zio.aws.omics.model.ReferenceFilter.ReadOnly = new Wrapper(impl)
}
