package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.ReferenceArn
import scala.jdk.CollectionConverters._
final case class ReferenceItem(
    referenceArn: Optional[ReferenceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReferenceItem = {
    import ReferenceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReferenceItem
      .builder()
      .optionallyWith(
        referenceArn.map(value => ReferenceArn.unwrap(value): java.lang.String)
      )(_.referenceArn)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReferenceItem.ReadOnly =
    zio.aws.omics.model.ReferenceItem.wrap(buildAwsValue())
}
object ReferenceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReferenceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReferenceItem =
      zio.aws.omics.model.ReferenceItem(referenceArn.map(value => value))
    def referenceArn: Optional[ReferenceArn]
    def getReferenceArn: ZIO[Any, AwsError, ReferenceArn] =
      AwsError.unwrapOptionField("referenceArn", referenceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReferenceItem
  ) extends zio.aws.omics.model.ReferenceItem.ReadOnly {
    override val referenceArn: Optional[ReferenceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceArn())
      .map(value => zio.aws.omics.model.primitives.ReferenceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReferenceItem
  ): zio.aws.omics.model.ReferenceItem.ReadOnly = new Wrapper(impl)
}
