package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait ReferenceStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.ReferenceStatus
}
object ReferenceStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.ReferenceStatus
  ): zio.aws.omics.model.ReferenceStatus = value match {
    case software.amazon.awssdk.services.omics.model.ReferenceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.ReferenceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.omics.model.ReferenceStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.omics.model.ReferenceStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceStatus =
      software.amazon.awssdk.services.omics.model.ReferenceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.omics.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceStatus =
      software.amazon.awssdk.services.omics.model.ReferenceStatus.ACTIVE
  }
  case object DELETING extends zio.aws.omics.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceStatus =
      software.amazon.awssdk.services.omics.model.ReferenceStatus.DELETING
  }
  case object DELETED extends zio.aws.omics.model.ReferenceStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.ReferenceStatus =
      software.amazon.awssdk.services.omics.model.ReferenceStatus.DELETED
  }
}
