package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  ReferenceStoreName,
  SyntheticTimestamp_date_time
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReferenceStoreFilter(
    createdAfter: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBefore: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    name: Optional[ReferenceStoreName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ReferenceStoreFilter = {
    import ReferenceStoreFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ReferenceStoreFilter
      .builder()
      .optionallyWith(
        createdAfter.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdBefore)
      .optionallyWith(
        name.map(value => ReferenceStoreName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ReferenceStoreFilter.ReadOnly =
    zio.aws.omics.model.ReferenceStoreFilter.wrap(buildAwsValue())
}
object ReferenceStoreFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ReferenceStoreFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ReferenceStoreFilter =
      zio.aws.omics.model.ReferenceStoreFilter(
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        name.map(value => value)
      )
    def createdAfter: Optional[SyntheticTimestamp_date_time]
    def createdBefore: Optional[SyntheticTimestamp_date_time]
    def name: Optional[ReferenceStoreName]
    def getCreatedAfter: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getName: ZIO[Any, AwsError, ReferenceStoreName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ReferenceStoreFilter
  ) extends zio.aws.omics.model.ReferenceStoreFilter.ReadOnly {
    override val createdAfter: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAfter())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBefore: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBefore())
        .map(value =>
          zio.aws.omics.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val name: Optional[ReferenceStoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.ReferenceStoreName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ReferenceStoreFilter
  ): zio.aws.omics.model.ReferenceStoreFilter.ReadOnly = new Wrapper(impl)
}
