package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RunGroupArn,
  RunGroupName,
  RunGroupListItemMaxDurationInteger,
  RunGroupListItemMaxRunsInteger,
  RunGroupTimestamp,
  RunGroupListItemMaxCpusInteger,
  RunGroupId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RunGroupListItem(
    arn: Optional[RunGroupArn] = Optional.Absent,
    creationTime: Optional[RunGroupTimestamp] = Optional.Absent,
    id: Optional[RunGroupId] = Optional.Absent,
    maxCpus: Optional[RunGroupListItemMaxCpusInteger] = Optional.Absent,
    maxDuration: Optional[RunGroupListItemMaxDurationInteger] = Optional.Absent,
    maxRuns: Optional[RunGroupListItemMaxRunsInteger] = Optional.Absent,
    name: Optional[RunGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.RunGroupListItem = {
    import RunGroupListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.RunGroupListItem
      .builder()
      .optionallyWith(
        arn.map(value => RunGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationTime.map(value => RunGroupTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        id.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        maxCpus.map(value =>
          RunGroupListItemMaxCpusInteger.unwrap(value): Integer
        )
      )(_.maxCpus)
      .optionallyWith(
        maxDuration.map(value =>
          RunGroupListItemMaxDurationInteger.unwrap(value): Integer
        )
      )(_.maxDuration)
      .optionallyWith(
        maxRuns.map(value =>
          RunGroupListItemMaxRunsInteger.unwrap(value): Integer
        )
      )(_.maxRuns)
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.RunGroupListItem.ReadOnly =
    zio.aws.omics.model.RunGroupListItem.wrap(buildAwsValue())
}
object RunGroupListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.RunGroupListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.RunGroupListItem =
      zio.aws.omics.model.RunGroupListItem(
        arn.map(value => value),
        creationTime.map(value => value),
        id.map(value => value),
        maxCpus.map(value => value),
        maxDuration.map(value => value),
        maxRuns.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[RunGroupArn]
    def creationTime: Optional[RunGroupTimestamp]
    def id: Optional[RunGroupId]
    def maxCpus: Optional[RunGroupListItemMaxCpusInteger]
    def maxDuration: Optional[RunGroupListItemMaxDurationInteger]
    def maxRuns: Optional[RunGroupListItemMaxRunsInteger]
    def name: Optional[RunGroupName]
    def getArn: ZIO[Any, AwsError, RunGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, RunGroupTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getMaxCpus: ZIO[Any, AwsError, RunGroupListItemMaxCpusInteger] =
      AwsError.unwrapOptionField("maxCpus", maxCpus)
    def getMaxDuration: ZIO[Any, AwsError, RunGroupListItemMaxDurationInteger] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getMaxRuns: ZIO[Any, AwsError, RunGroupListItemMaxRunsInteger] =
      AwsError.unwrapOptionField("maxRuns", maxRuns)
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.RunGroupListItem
  ) extends zio.aws.omics.model.RunGroupListItem.ReadOnly {
    override val arn: Optional[RunGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunGroupArn(value))
    override val creationTime: Optional[RunGroupTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.omics.model.primitives.RunGroupTimestamp(value))
    override val id: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val maxCpus: Optional[RunGroupListItemMaxCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCpus())
        .map(value =>
          zio.aws.omics.model.primitives.RunGroupListItemMaxCpusInteger(value)
        )
    override val maxDuration: Optional[RunGroupListItemMaxDurationInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDuration())
        .map(value =>
          zio.aws.omics.model.primitives
            .RunGroupListItemMaxDurationInteger(value)
        )
    override val maxRuns: Optional[RunGroupListItemMaxRunsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuns())
        .map(value =>
          zio.aws.omics.model.primitives.RunGroupListItemMaxRunsInteger(value)
        )
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.RunGroupListItem
  ): zio.aws.omics.model.RunGroupListItem.ReadOnly = new Wrapper(impl)
}
