package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RunArn,
  RunListItemStorageCapacityInteger,
  RunTimestamp,
  RunName,
  RunListItemPriorityInteger,
  WorkflowId,
  RunId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RunListItem(
    arn: Optional[RunArn] = Optional.Absent,
    creationTime: Optional[RunTimestamp] = Optional.Absent,
    id: Optional[RunId] = Optional.Absent,
    name: Optional[RunName] = Optional.Absent,
    priority: Optional[RunListItemPriorityInteger] = Optional.Absent,
    startTime: Optional[RunTimestamp] = Optional.Absent,
    status: Optional[zio.aws.omics.model.RunStatus] = Optional.Absent,
    stopTime: Optional[RunTimestamp] = Optional.Absent,
    storageCapacity: Optional[RunListItemStorageCapacityInteger] =
      Optional.Absent,
    workflowId: Optional[WorkflowId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.RunListItem = {
    import RunListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.RunListItem
      .builder()
      .optionallyWith(arn.map(value => RunArn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationTime.map(value => RunTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(id.map(value => RunId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => RunName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        priority.map(value => RunListItemPriorityInteger.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        startTime.map(value => RunTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        stopTime.map(value => RunTimestamp.unwrap(value): Instant)
      )(_.stopTime)
      .optionallyWith(
        storageCapacity.map(value =>
          RunListItemStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        workflowId.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.workflowId)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.RunListItem.ReadOnly =
    zio.aws.omics.model.RunListItem.wrap(buildAwsValue())
}
object RunListItem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.RunListItem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.RunListItem =
      zio.aws.omics.model.RunListItem(
        arn.map(value => value),
        creationTime.map(value => value),
        id.map(value => value),
        name.map(value => value),
        priority.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        stopTime.map(value => value),
        storageCapacity.map(value => value),
        workflowId.map(value => value)
      )
    def arn: Optional[RunArn]
    def creationTime: Optional[RunTimestamp]
    def id: Optional[RunId]
    def name: Optional[RunName]
    def priority: Optional[RunListItemPriorityInteger]
    def startTime: Optional[RunTimestamp]
    def status: Optional[zio.aws.omics.model.RunStatus]
    def stopTime: Optional[RunTimestamp]
    def storageCapacity: Optional[RunListItemStorageCapacityInteger]
    def workflowId: Optional[WorkflowId]
    def getArn: ZIO[Any, AwsError, RunArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, RunTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getId: ZIO[Any, AwsError, RunId] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, RunName] =
      AwsError.unwrapOptionField("name", name)
    def getPriority: ZIO[Any, AwsError, RunListItemPriorityInteger] =
      AwsError.unwrapOptionField("priority", priority)
    def getStartTime: ZIO[Any, AwsError, RunTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.RunStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStopTime: ZIO[Any, AwsError, RunTimestamp] =
      AwsError.unwrapOptionField("stopTime", stopTime)
    def getStorageCapacity
        : ZIO[Any, AwsError, RunListItemStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getWorkflowId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("workflowId", workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.RunListItem
  ) extends zio.aws.omics.model.RunListItem.ReadOnly {
    override val arn: Optional[RunArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunArn(value))
    override val creationTime: Optional[RunTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.omics.model.primitives.RunTimestamp(value))
    override val id: Optional[RunId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunId(value))
    override val name: Optional[RunName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunName(value))
    override val priority: Optional[RunListItemPriorityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.omics.model.primitives.RunListItemPriorityInteger(value)
        )
    override val startTime: Optional[RunTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.omics.model.primitives.RunTimestamp(value))
    override val status: Optional[zio.aws.omics.model.RunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.RunStatus.wrap(value))
    override val stopTime: Optional[RunTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.omics.model.primitives.RunTimestamp(value))
    override val storageCapacity: Optional[RunListItemStorageCapacityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value =>
          zio.aws.omics.model.primitives
            .RunListItemStorageCapacityInteger(value)
        )
    override val workflowId: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.RunListItem
  ): zio.aws.omics.model.RunListItem.ReadOnly = new Wrapper(impl)
}
