package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.GeneratedFrom
import scala.jdk.CollectionConverters._
final case class SequenceInformation(
    alignment: Optional[String] = Optional.Absent,
    generatedFrom: Optional[GeneratedFrom] = Optional.Absent,
    totalBaseCount: Optional[Long] = Optional.Absent,
    totalReadCount: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.SequenceInformation = {
    import SequenceInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.SequenceInformation
      .builder()
      .optionallyWith(alignment.map(value => value: java.lang.String))(
        _.alignment
      )
      .optionallyWith(
        generatedFrom.map(value =>
          GeneratedFrom.unwrap(value): java.lang.String
        )
      )(_.generatedFrom)
      .optionallyWith(totalBaseCount.map(value => value: java.lang.Long))(
        _.totalBaseCount
      )
      .optionallyWith(totalReadCount.map(value => value: java.lang.Long))(
        _.totalReadCount
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.SequenceInformation.ReadOnly =
    zio.aws.omics.model.SequenceInformation.wrap(buildAwsValue())
}
object SequenceInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.SequenceInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.SequenceInformation =
      zio.aws.omics.model.SequenceInformation(
        alignment.map(value => value),
        generatedFrom.map(value => value),
        totalBaseCount.map(value => value),
        totalReadCount.map(value => value)
      )
    def alignment: Optional[String]
    def generatedFrom: Optional[GeneratedFrom]
    def totalBaseCount: Optional[Long]
    def totalReadCount: Optional[Long]
    def getAlignment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("alignment", alignment)
    def getGeneratedFrom: ZIO[Any, AwsError, GeneratedFrom] =
      AwsError.unwrapOptionField("generatedFrom", generatedFrom)
    def getTotalBaseCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalBaseCount", totalBaseCount)
    def getTotalReadCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("totalReadCount", totalReadCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.SequenceInformation
  ) extends zio.aws.omics.model.SequenceInformation.ReadOnly {
    override val alignment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.alignment())
      .map(value => value: String)
    override val generatedFrom: Optional[GeneratedFrom] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedFrom())
      .map(value => zio.aws.omics.model.primitives.GeneratedFrom(value))
    override val totalBaseCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalBaseCount())
      .map(value => value: Long)
    override val totalReadCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalReadCount())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.SequenceInformation
  ): zio.aws.omics.model.SequenceInformation.ReadOnly = new Wrapper(impl)
}
