package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class SourceFiles(
    source1: S3Uri,
    source2: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.SourceFiles = {
    import SourceFiles.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.SourceFiles
      .builder()
      .source1(S3Uri.unwrap(source1): java.lang.String)
      .optionallyWith(
        source2.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.source2)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.SourceFiles.ReadOnly =
    zio.aws.omics.model.SourceFiles.wrap(buildAwsValue())
}
object SourceFiles {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.SourceFiles] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.SourceFiles =
      zio.aws.omics.model.SourceFiles(source1, source2.map(value => value))
    def source1: S3Uri
    def source2: Optional[S3Uri]
    def getSource1: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(source1)
    def getSource2: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("source2", source2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.SourceFiles
  ) extends zio.aws.omics.model.SourceFiles.ReadOnly {
    override val source1: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.source1())
    override val source2: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.source2())
      .map(value => zio.aws.omics.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.SourceFiles
  ): zio.aws.omics.model.SourceFiles.ReadOnly = new Wrapper(impl)
}
