package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.SseConfigKeyArnString
import scala.jdk.CollectionConverters._
final case class SseConfig(
    keyArn: Optional[SseConfigKeyArnString] = Optional.Absent,
    `type`: zio.aws.omics.model.EncryptionType
) {
  def buildAwsValue(): software.amazon.awssdk.services.omics.model.SseConfig = {
    import SseConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.SseConfig
      .builder()
      .optionallyWith(
        keyArn.map(value =>
          SseConfigKeyArnString.unwrap(value): java.lang.String
        )
      )(_.keyArn)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.SseConfig.ReadOnly =
    zio.aws.omics.model.SseConfig.wrap(buildAwsValue())
}
object SseConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.SseConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.SseConfig =
      zio.aws.omics.model.SseConfig(keyArn.map(value => value), `type`)
    def keyArn: Optional[SseConfigKeyArnString]
    def `type`: zio.aws.omics.model.EncryptionType
    def getKeyArn: ZIO[Any, AwsError, SseConfigKeyArnString] =
      AwsError.unwrapOptionField("keyArn", keyArn)
    def getType: ZIO[Any, Nothing, zio.aws.omics.model.EncryptionType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.SseConfig
  ) extends zio.aws.omics.model.SseConfig.ReadOnly {
    override val keyArn: Optional[SseConfigKeyArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyArn())
      .map(value => zio.aws.omics.model.primitives.SseConfigKeyArnString(value))
    override val `type`: zio.aws.omics.model.EncryptionType =
      zio.aws.omics.model.EncryptionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.SseConfig
  ): zio.aws.omics.model.SseConfig.ReadOnly = new Wrapper(impl)
}
