package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{RunLeftNormalization, Arn, StoreName}
import scala.jdk.CollectionConverters._
final case class StartAnnotationImportJobRequest(
    destinationName: StoreName,
    formatOptions: Optional[zio.aws.omics.model.FormatOptions] =
      Optional.Absent,
    items: Iterable[zio.aws.omics.model.AnnotationImportItemSource],
    roleArn: Arn,
    runLeftNormalization: Optional[RunLeftNormalization] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest = {
    import StartAnnotationImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
      .builder()
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        runLeftNormalization.map(value =>
          RunLeftNormalization.unwrap(value): java.lang.Boolean
        )
      )(_.runLeftNormalization)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartAnnotationImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartAnnotationImportJobRequest.wrap(buildAwsValue())
}
object StartAnnotationImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartAnnotationImportJobRequest =
      zio.aws.omics.model.StartAnnotationImportJobRequest(
        destinationName,
        formatOptions.map(value => value.asEditable),
        items.map { item =>
          item.asEditable
        },
        roleArn,
        runLeftNormalization.map(value => value)
      )
    def destinationName: StoreName
    def formatOptions: Optional[zio.aws.omics.model.FormatOptions.ReadOnly]
    def items: List[zio.aws.omics.model.AnnotationImportItemSource.ReadOnly]
    def roleArn: Arn
    def runLeftNormalization: Optional[RunLeftNormalization]
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.AnnotationImportItemSource.ReadOnly
    ]] = ZIO.succeed(items)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getRunLeftNormalization: ZIO[Any, AwsError, RunLeftNormalization] =
      AwsError.unwrapOptionField("runLeftNormalization", runLeftNormalization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
  ) extends zio.aws.omics.model.StartAnnotationImportJobRequest.ReadOnly {
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val formatOptions
        : Optional[zio.aws.omics.model.FormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatOptions())
        .map(value => zio.aws.omics.model.FormatOptions.wrap(value))
    override val items
        : List[zio.aws.omics.model.AnnotationImportItemSource.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.AnnotationImportItemSource.wrap(item)
      }
      .toList
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val runLeftNormalization: Optional[RunLeftNormalization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runLeftNormalization())
        .map(value =>
          zio.aws.omics.model.primitives.RunLeftNormalization(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest
  ): zio.aws.omics.model.StartAnnotationImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
