package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class StartAnnotationImportJobResponse(jobId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse = {
    import StartAnnotationImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse
      .builder()
      .jobId(ResourceId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly =
    zio.aws.omics.model.StartAnnotationImportJobResponse.wrap(buildAwsValue())
}
object StartAnnotationImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartAnnotationImportJobResponse =
      zio.aws.omics.model.StartAnnotationImportJobResponse(jobId)
    def jobId: ResourceId
    def getJobId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse
  ) extends zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly {
    override val jobId: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse
  ): zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
