package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ReadSetId
import scala.jdk.CollectionConverters._
final case class StartReadSetActivationJobSourceItem(readSetId: ReadSetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetActivationJobSourceItem = {
    import StartReadSetActivationJobSourceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetActivationJobSourceItem
      .builder()
      .readSetId(ReadSetId.unwrap(readSetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.StartReadSetActivationJobSourceItem.ReadOnly =
    zio.aws.omics.model.StartReadSetActivationJobSourceItem
      .wrap(buildAwsValue())
}
object StartReadSetActivationJobSourceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetActivationJobSourceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetActivationJobSourceItem =
      zio.aws.omics.model.StartReadSetActivationJobSourceItem(readSetId)
    def readSetId: ReadSetId
    def getReadSetId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(readSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetActivationJobSourceItem
  ) extends zio.aws.omics.model.StartReadSetActivationJobSourceItem.ReadOnly {
    override val readSetId: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.readSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetActivationJobSourceItem
  ): zio.aws.omics.model.StartReadSetActivationJobSourceItem.ReadOnly =
    new Wrapper(impl)
}
