package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  SequenceStoreId,
  RoleArn,
  S3Destination,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class StartReadSetExportJobRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    destination: S3Destination,
    roleArn: RoleArn,
    sequenceStoreId: SequenceStoreId,
    sources: Iterable[zio.aws.omics.model.ExportReadSet]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest = {
    import StartReadSetExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .destination(S3Destination.unwrap(destination): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReadSetExportJobRequest.ReadOnly =
    zio.aws.omics.model.StartReadSetExportJobRequest.wrap(buildAwsValue())
}
object StartReadSetExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetExportJobRequest =
      zio.aws.omics.model.StartReadSetExportJobRequest(
        clientToken.map(value => value),
        destination,
        roleArn,
        sequenceStoreId,
        sources.map { item =>
          item.asEditable
        }
      )
    def clientToken: Optional[ClientToken]
    def destination: S3Destination
    def roleArn: RoleArn
    def sequenceStoreId: SequenceStoreId
    def sources: List[zio.aws.omics.model.ExportReadSet.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDestination: ZIO[Any, Nothing, S3Destination] =
      ZIO.succeed(destination)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getSources
        : ZIO[Any, Nothing, List[zio.aws.omics.model.ExportReadSet.ReadOnly]] =
      ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest
  ) extends zio.aws.omics.model.StartReadSetExportJobRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val destination: S3Destination =
      zio.aws.omics.model.primitives.S3Destination(impl.destination())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val sources: List[zio.aws.omics.model.ExportReadSet.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.omics.model.ExportReadSet.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest
  ): zio.aws.omics.model.StartReadSetExportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
