package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{SequenceStoreId, RoleArn, ClientToken}
import scala.jdk.CollectionConverters._
final case class StartReadSetImportJobRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    roleArn: RoleArn,
    sequenceStoreId: SequenceStoreId,
    sources: Iterable[zio.aws.omics.model.StartReadSetImportJobSourceItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest = {
    import StartReadSetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReadSetImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartReadSetImportJobRequest.wrap(buildAwsValue())
}
object StartReadSetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReadSetImportJobRequest =
      zio.aws.omics.model.StartReadSetImportJobRequest(
        clientToken.map(value => value),
        roleArn,
        sequenceStoreId,
        sources.map { item =>
          item.asEditable
        }
      )
    def clientToken: Optional[ClientToken]
    def roleArn: RoleArn
    def sequenceStoreId: SequenceStoreId
    def sources
        : List[zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
  ) extends zio.aws.omics.model.StartReadSetImportJobRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val sources
        : List[zio.aws.omics.model.StartReadSetImportJobSourceItem.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.omics.model.StartReadSetImportJobSourceItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest
  ): zio.aws.omics.model.StartReadSetImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
