package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{RoleArn, ReferenceStoreId, ClientToken}
import scala.jdk.CollectionConverters._
final case class StartReferenceImportJobRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    referenceStoreId: ReferenceStoreId,
    roleArn: RoleArn,
    sources: Iterable[zio.aws.omics.model.StartReferenceImportJobSourceItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest = {
    import StartReferenceImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .sources(sources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReferenceImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartReferenceImportJobRequest.wrap(buildAwsValue())
}
object StartReferenceImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReferenceImportJobRequest =
      zio.aws.omics.model.StartReferenceImportJobRequest(
        clientToken.map(value => value),
        referenceStoreId,
        roleArn,
        sources.map { item =>
          item.asEditable
        }
      )
    def clientToken: Optional[ClientToken]
    def referenceStoreId: ReferenceStoreId
    def roleArn: RoleArn
    def sources
        : List[zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSources: ZIO[Any, Nothing, List[
      zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly
    ]] = ZIO.succeed(sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
  ) extends zio.aws.omics.model.StartReferenceImportJobRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.omics.model.primitives.ClientToken(value))
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val sources
        : List[zio.aws.omics.model.StartReferenceImportJobSourceItem.ReadOnly] =
      impl
        .sources()
        .asScala
        .map { item =>
          zio.aws.omics.model.StartReferenceImportJobSourceItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest
  ): zio.aws.omics.model.StartReferenceImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
