package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  RoleArn,
  ReferenceStoreId,
  ImportJobId,
  SyntheticTimestamp_date_time
}
import scala.jdk.CollectionConverters._
final case class StartReferenceImportJobResponse(
    creationTime: SyntheticTimestamp_date_time,
    id: ImportJobId,
    referenceStoreId: ReferenceStoreId,
    roleArn: RoleArn,
    status: zio.aws.omics.model.ReferenceImportJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse = {
    import StartReferenceImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse
      .builder()
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .id(ImportJobId.unwrap(id): java.lang.String)
      .referenceStoreId(
        ReferenceStoreId.unwrap(referenceStoreId): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly =
    zio.aws.omics.model.StartReferenceImportJobResponse.wrap(buildAwsValue())
}
object StartReferenceImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartReferenceImportJobResponse =
      zio.aws.omics.model.StartReferenceImportJobResponse(
        creationTime,
        id,
        referenceStoreId,
        roleArn,
        status
      )
    def creationTime: SyntheticTimestamp_date_time
    def id: ImportJobId
    def referenceStoreId: ReferenceStoreId
    def roleArn: RoleArn
    def status: zio.aws.omics.model.ReferenceImportJobStatus
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getId: ZIO[Any, Nothing, ImportJobId] = ZIO.succeed(id)
    def getReferenceStoreId: ZIO[Any, Nothing, ReferenceStoreId] =
      ZIO.succeed(referenceStoreId)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceImportJobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse
  ) extends zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly {
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val id: ImportJobId =
      zio.aws.omics.model.primitives.ImportJobId(impl.id())
    override val referenceStoreId: ReferenceStoreId =
      zio.aws.omics.model.primitives.ReferenceStoreId(impl.referenceStoreId())
    override val roleArn: RoleArn =
      zio.aws.omics.model.primitives.RoleArn(impl.roleArn())
    override val status: zio.aws.omics.model.ReferenceImportJobStatus =
      zio.aws.omics.model.ReferenceImportJobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse
  ): zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
