package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  RunRequestId,
  RunRoleArn,
  RunOutputUri,
  TagValue,
  StartRunRequestPriorityInteger,
  StartRunRequestStorageCapacityInteger,
  RunName,
  RunGroupId,
  WorkflowId,
  TagKey,
  RunId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import software.amazon.awssdk.core.document.Document
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartRunRequest(
    logLevel: Optional[zio.aws.omics.model.RunLogLevel] = Optional.Absent,
    name: Optional[RunName] = Optional.Absent,
    outputUri: Optional[RunOutputUri] = Optional.Absent,
    parameters: Optional[zio.aws.omics.model.RunParameters] = Optional.Absent,
    priority: Optional[StartRunRequestPriorityInteger] = Optional.Absent,
    requestId: RunRequestId,
    roleArn: RunRoleArn,
    runGroupId: Optional[RunGroupId] = Optional.Absent,
    runId: Optional[RunId] = Optional.Absent,
    storageCapacity: Optional[StartRunRequestStorageCapacityInteger] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workflowId: Optional[WorkflowId] = Optional.Absent,
    workflowType: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartRunRequest = {
    import StartRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartRunRequest
      .builder()
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(
        name.map(value => RunName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        outputUri.map(value => RunOutputUri.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(parameters.map(value => value))(_.parameters)
      .optionallyWith(
        priority.map(value =>
          StartRunRequestPriorityInteger.unwrap(value): Integer
        )
      )(_.priority)
      .requestId(RunRequestId.unwrap(requestId): java.lang.String)
      .roleArn(RunRoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        runGroupId.map(value => RunGroupId.unwrap(value): java.lang.String)
      )(_.runGroupId)
      .optionallyWith(
        runId.map(value => RunId.unwrap(value): java.lang.String)
      )(_.runId)
      .optionallyWith(
        storageCapacity.map(value =>
          StartRunRequestStorageCapacityInteger.unwrap(value): Integer
        )
      )(_.storageCapacity)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workflowId.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.workflowId)
      .optionallyWith(workflowType.map(value => value.unwrap))(_.workflowType)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartRunRequest.ReadOnly =
    zio.aws.omics.model.StartRunRequest.wrap(buildAwsValue())
}
object StartRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartRunRequest =
      zio.aws.omics.model.StartRunRequest(
        logLevel.map(value => value),
        name.map(value => value),
        outputUri.map(value => value),
        parameters.map(value => value),
        priority.map(value => value),
        requestId,
        roleArn,
        runGroupId.map(value => value),
        runId.map(value => value),
        storageCapacity.map(value => value),
        tags.map(value => value),
        workflowId.map(value => value),
        workflowType.map(value => value)
      )
    def logLevel: Optional[zio.aws.omics.model.RunLogLevel]
    def name: Optional[RunName]
    def outputUri: Optional[RunOutputUri]
    def parameters: Optional[Document]
    def priority: Optional[StartRunRequestPriorityInteger]
    def requestId: RunRequestId
    def roleArn: RunRoleArn
    def runGroupId: Optional[RunGroupId]
    def runId: Optional[RunId]
    def storageCapacity: Optional[StartRunRequestStorageCapacityInteger]
    def tags: Optional[Map[TagKey, TagValue]]
    def workflowId: Optional[WorkflowId]
    def workflowType: Optional[zio.aws.omics.model.WorkflowType]
    def getLogLevel: ZIO[Any, AwsError, zio.aws.omics.model.RunLogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getName: ZIO[Any, AwsError, RunName] =
      AwsError.unwrapOptionField("name", name)
    def getOutputUri: ZIO[Any, AwsError, RunOutputUri] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getParameters: ZIO[Any, AwsError, Document] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getPriority: ZIO[Any, AwsError, StartRunRequestPriorityInteger] =
      AwsError.unwrapOptionField("priority", priority)
    def getRequestId: ZIO[Any, Nothing, RunRequestId] = ZIO.succeed(requestId)
    def getRoleArn: ZIO[Any, Nothing, RunRoleArn] = ZIO.succeed(roleArn)
    def getRunGroupId: ZIO[Any, AwsError, RunGroupId] =
      AwsError.unwrapOptionField("runGroupId", runGroupId)
    def getRunId: ZIO[Any, AwsError, RunId] =
      AwsError.unwrapOptionField("runId", runId)
    def getStorageCapacity
        : ZIO[Any, AwsError, StartRunRequestStorageCapacityInteger] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkflowId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getWorkflowType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("workflowType", workflowType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartRunRequest
  ) extends zio.aws.omics.model.StartRunRequest.ReadOnly {
    override val logLevel: Optional[zio.aws.omics.model.RunLogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.omics.model.RunLogLevel.wrap(value))
    override val name: Optional[RunName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunName(value))
    override val outputUri: Optional[RunOutputUri] = zio.aws.core.internal
      .optionalFromNullable(impl.outputUri())
      .map(value => zio.aws.omics.model.primitives.RunOutputUri(value))
    override val parameters: Optional[Document] =
      zio.aws.core.internal.optionalFromNullable(impl.parameters())
    override val priority: Optional[StartRunRequestPriorityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.omics.model.primitives.StartRunRequestPriorityInteger(value)
        )
    override val requestId: RunRequestId =
      zio.aws.omics.model.primitives.RunRequestId(impl.requestId())
    override val roleArn: RunRoleArn =
      zio.aws.omics.model.primitives.RunRoleArn(impl.roleArn())
    override val runGroupId: Optional[RunGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.runGroupId())
      .map(value => zio.aws.omics.model.primitives.RunGroupId(value))
    override val runId: Optional[RunId] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.omics.model.primitives.RunId(value))
    override val storageCapacity
        : Optional[StartRunRequestStorageCapacityInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value =>
          zio.aws.omics.model.primitives
            .StartRunRequestStorageCapacityInteger(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workflowId: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val workflowType: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowType())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartRunRequest
  ): zio.aws.omics.model.StartRunRequest.ReadOnly = new Wrapper(impl)
}
