package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{TagValue, TagKey, RunId, RunArn}
import scala.jdk.CollectionConverters._
final case class StartRunResponse(
    arn: Optional[RunArn] = Optional.Absent,
    id: Optional[RunId] = Optional.Absent,
    status: Optional[zio.aws.omics.model.RunStatus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartRunResponse = {
    import StartRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartRunResponse
      .builder()
      .optionallyWith(arn.map(value => RunArn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => RunId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartRunResponse.ReadOnly =
    zio.aws.omics.model.StartRunResponse.wrap(buildAwsValue())
}
object StartRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartRunResponse =
      zio.aws.omics.model.StartRunResponse(
        arn.map(value => value),
        id.map(value => value),
        status.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[RunArn]
    def id: Optional[RunId]
    def status: Optional[zio.aws.omics.model.RunStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, RunArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, RunId] = AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.RunStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartRunResponse
  ) extends zio.aws.omics.model.StartRunResponse.ReadOnly {
    override val arn: Optional[RunArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.RunArn(value))
    override val id: Optional[RunId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.RunId(value))
    override val status: Optional[zio.aws.omics.model.RunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.RunStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives
              .TagKey(key) -> zio.aws.omics.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartRunResponse
  ): zio.aws.omics.model.StartRunResponse.ReadOnly = new Wrapper(impl)
}
