package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{RunLeftNormalization, Arn, StoreName}
import scala.jdk.CollectionConverters._
final case class StartVariantImportJobRequest(
    destinationName: StoreName,
    items: Iterable[zio.aws.omics.model.VariantImportItemSource],
    roleArn: Arn,
    runLeftNormalization: Optional[RunLeftNormalization] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest = {
    import StartVariantImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
      .builder()
      .destinationName(StoreName.unwrap(destinationName): java.lang.String)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        runLeftNormalization.map(value =>
          RunLeftNormalization.unwrap(value): java.lang.Boolean
        )
      )(_.runLeftNormalization)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartVariantImportJobRequest.ReadOnly =
    zio.aws.omics.model.StartVariantImportJobRequest.wrap(buildAwsValue())
}
object StartVariantImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartVariantImportJobRequest =
      zio.aws.omics.model.StartVariantImportJobRequest(
        destinationName,
        items.map { item =>
          item.asEditable
        },
        roleArn,
        runLeftNormalization.map(value => value)
      )
    def destinationName: StoreName
    def items: List[zio.aws.omics.model.VariantImportItemSource.ReadOnly]
    def roleArn: Arn
    def runLeftNormalization: Optional[RunLeftNormalization]
    def getDestinationName: ZIO[Any, Nothing, StoreName] =
      ZIO.succeed(destinationName)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.omics.model.VariantImportItemSource.ReadOnly
    ]] = ZIO.succeed(items)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getRunLeftNormalization: ZIO[Any, AwsError, RunLeftNormalization] =
      AwsError.unwrapOptionField("runLeftNormalization", runLeftNormalization)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
  ) extends zio.aws.omics.model.StartVariantImportJobRequest.ReadOnly {
    override val destinationName: StoreName =
      zio.aws.omics.model.primitives.StoreName(impl.destinationName())
    override val items
        : List[zio.aws.omics.model.VariantImportItemSource.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.omics.model.VariantImportItemSource.wrap(item)
      }
      .toList
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val runLeftNormalization: Optional[RunLeftNormalization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runLeftNormalization())
        .map(value =>
          zio.aws.omics.model.primitives.RunLeftNormalization(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest
  ): zio.aws.omics.model.StartVariantImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
