package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class StartVariantImportJobResponse(jobId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse = {
    import StartVariantImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse
      .builder()
      .jobId(ResourceId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly =
    zio.aws.omics.model.StartVariantImportJobResponse.wrap(buildAwsValue())
}
object StartVariantImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.StartVariantImportJobResponse =
      zio.aws.omics.model.StartVariantImportJobResponse(jobId)
    def jobId: ResourceId
    def getJobId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse
  ) extends zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly {
    override val jobId: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse
  ): zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
