package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  TaskName,
  TaskTimestamp,
  TaskListItemMemoryInteger,
  TaskListItemCpusInteger,
  TaskId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TaskListItem(
    cpus: Optional[TaskListItemCpusInteger] = Optional.Absent,
    creationTime: Optional[TaskTimestamp] = Optional.Absent,
    memory: Optional[TaskListItemMemoryInteger] = Optional.Absent,
    name: Optional[TaskName] = Optional.Absent,
    startTime: Optional[TaskTimestamp] = Optional.Absent,
    status: Optional[zio.aws.omics.model.TaskStatus] = Optional.Absent,
    stopTime: Optional[TaskTimestamp] = Optional.Absent,
    taskId: Optional[TaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.TaskListItem = {
    import TaskListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.TaskListItem
      .builder()
      .optionallyWith(
        cpus.map(value => TaskListItemCpusInteger.unwrap(value): Integer)
      )(_.cpus)
      .optionallyWith(
        creationTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        memory.map(value => TaskListItemMemoryInteger.unwrap(value): Integer)
      )(_.memory)
      .optionallyWith(
        name.map(value => TaskName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        startTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        stopTime.map(value => TaskTimestamp.unwrap(value): Instant)
      )(_.stopTime)
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.TaskListItem.ReadOnly =
    zio.aws.omics.model.TaskListItem.wrap(buildAwsValue())
}
object TaskListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.TaskListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.TaskListItem =
      zio.aws.omics.model.TaskListItem(
        cpus.map(value => value),
        creationTime.map(value => value),
        memory.map(value => value),
        name.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        stopTime.map(value => value),
        taskId.map(value => value)
      )
    def cpus: Optional[TaskListItemCpusInteger]
    def creationTime: Optional[TaskTimestamp]
    def memory: Optional[TaskListItemMemoryInteger]
    def name: Optional[TaskName]
    def startTime: Optional[TaskTimestamp]
    def status: Optional[zio.aws.omics.model.TaskStatus]
    def stopTime: Optional[TaskTimestamp]
    def taskId: Optional[TaskId]
    def getCpus: ZIO[Any, AwsError, TaskListItemCpusInteger] =
      AwsError.unwrapOptionField("cpus", cpus)
    def getCreationTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getMemory: ZIO[Any, AwsError, TaskListItemMemoryInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getName: ZIO[Any, AwsError, TaskName] =
      AwsError.unwrapOptionField("name", name)
    def getStartTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStopTime: ZIO[Any, AwsError, TaskTimestamp] =
      AwsError.unwrapOptionField("stopTime", stopTime)
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.TaskListItem
  ) extends zio.aws.omics.model.TaskListItem.ReadOnly {
    override val cpus: Optional[TaskListItemCpusInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.cpus())
      .map(value =>
        zio.aws.omics.model.primitives.TaskListItemCpusInteger(value)
      )
    override val creationTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val memory: Optional[TaskListItemMemoryInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memory())
        .map(value =>
          zio.aws.omics.model.primitives.TaskListItemMemoryInteger(value)
        )
    override val name: Optional[TaskName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.TaskName(value))
    override val startTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val status: Optional[zio.aws.omics.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.TaskStatus.wrap(value))
    override val stopTime: Optional[TaskTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.omics.model.primitives.TaskTimestamp(value))
    override val taskId: Optional[TaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.taskId())
      .map(value => zio.aws.omics.model.primitives.TaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.TaskListItem
  ): zio.aws.omics.model.TaskListItem.ReadOnly = new Wrapper(impl)
}
