package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TsvOptions(
    readOptions: Optional[zio.aws.omics.model.ReadOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.TsvOptions = {
    import TsvOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.TsvOptions
      .builder()
      .optionallyWith(readOptions.map(value => value.buildAwsValue()))(
        _.readOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.TsvOptions.ReadOnly =
    zio.aws.omics.model.TsvOptions.wrap(buildAwsValue())
}
object TsvOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.TsvOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.TsvOptions =
      zio.aws.omics.model.TsvOptions(readOptions.map(value => value.asEditable))
    def readOptions: Optional[zio.aws.omics.model.ReadOptions.ReadOnly]
    def getReadOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.ReadOptions.ReadOnly] =
      AwsError.unwrapOptionField("readOptions", readOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.TsvOptions
  ) extends zio.aws.omics.model.TsvOptions.ReadOnly {
    override val readOptions
        : Optional[zio.aws.omics.model.ReadOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOptions())
        .map(value => zio.aws.omics.model.ReadOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.TsvOptions
  ): zio.aws.omics.model.TsvOptions.ReadOnly = new Wrapper(impl)
}
