package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  SchemaItemKeyString,
  FormatToHeaderValueString
}
import scala.jdk.CollectionConverters._
final case class TsvStoreOptions(
    annotationType: Optional[zio.aws.omics.model.AnnotationType] =
      Optional.Absent,
    formatToHeader: Optional[
      Map[zio.aws.omics.model.FormatToHeaderKey, FormatToHeaderValueString]
    ] = Optional.Absent,
    schema: Optional[
      Iterable[Map[SchemaItemKeyString, zio.aws.omics.model.SchemaValueType]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.TsvStoreOptions = {
    import TsvStoreOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.TsvStoreOptions
      .builder()
      .optionallyWith(annotationType.map(value => value.unwrap))(
        _.annotationType
      )
      .optionallyWith(
        formatToHeader.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (FormatToHeaderValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.formatToHeaderWithStrings)
      .optionallyWith(
        schema.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (SchemaItemKeyString
                  .unwrap(key): java.lang.String) -> value.unwrap.toString
              })
              .asJava
          }.asJavaCollection
        )
      )(_.schemaWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.TsvStoreOptions.ReadOnly =
    zio.aws.omics.model.TsvStoreOptions.wrap(buildAwsValue())
}
object TsvStoreOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.TsvStoreOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.TsvStoreOptions =
      zio.aws.omics.model.TsvStoreOptions(
        annotationType.map(value => value),
        formatToHeader.map(value => value),
        schema.map(value => value)
      )
    def annotationType: Optional[zio.aws.omics.model.AnnotationType]
    def formatToHeader: Optional[
      Map[zio.aws.omics.model.FormatToHeaderKey, FormatToHeaderValueString]
    ]
    def schema: Optional[
      List[Map[SchemaItemKeyString, zio.aws.omics.model.SchemaValueType]]
    ]
    def getAnnotationType
        : ZIO[Any, AwsError, zio.aws.omics.model.AnnotationType] =
      AwsError.unwrapOptionField("annotationType", annotationType)
    def getFormatToHeader: ZIO[Any, AwsError, Map[
      zio.aws.omics.model.FormatToHeaderKey,
      FormatToHeaderValueString
    ]] = AwsError.unwrapOptionField("formatToHeader", formatToHeader)
    def getSchema: ZIO[Any, AwsError, List[
      Map[SchemaItemKeyString, zio.aws.omics.model.SchemaValueType]
    ]] = AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.TsvStoreOptions
  ) extends zio.aws.omics.model.TsvStoreOptions.ReadOnly {
    override val annotationType: Optional[zio.aws.omics.model.AnnotationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.annotationType())
        .map(value => zio.aws.omics.model.AnnotationType.wrap(value))
    override val formatToHeader: Optional[
      Map[zio.aws.omics.model.FormatToHeaderKey, FormatToHeaderValueString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.formatToHeader())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.FormatToHeaderKey.wrap(
              key
            ) -> zio.aws.omics.model.primitives.FormatToHeaderValueString(value)
          })
          .toMap
      )
    override val schema: Optional[
      List[Map[SchemaItemKeyString, zio.aws.omics.model.SchemaValueType]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.omics.model.primitives.SchemaItemKeyString(
                key
              ) -> zio.aws.omics.model.SchemaValueType.wrap(value)
            })
            .toMap
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.TsvStoreOptions
  ): zio.aws.omics.model.TsvStoreOptions.ReadOnly = new Wrapper(impl)
}
