package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  UpdateTime,
  ResourceId,
  StoreDescription,
  CreationTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateAnnotationStoreResponse(
    creationTime: CreationTime,
    description: StoreDescription,
    id: ResourceId,
    name: String,
    reference: zio.aws.omics.model.ReferenceItem,
    status: zio.aws.omics.model.StoreStatus,
    storeFormat: Optional[zio.aws.omics.model.StoreFormat] = Optional.Absent,
    storeOptions: Optional[zio.aws.omics.model.StoreOptions] = Optional.Absent,
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse = {
    import UpdateAnnotationStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
      .builder()
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .description(StoreDescription.unwrap(description): java.lang.String)
      .id(ResourceId.unwrap(id): java.lang.String)
      .name(name: java.lang.String)
      .reference(reference.buildAwsValue())
      .status(status.unwrap)
      .optionallyWith(storeFormat.map(value => value.unwrap))(_.storeFormat)
      .optionallyWith(storeOptions.map(value => value.buildAwsValue()))(
        _.storeOptions
      )
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly =
    zio.aws.omics.model.UpdateAnnotationStoreResponse.wrap(buildAwsValue())
}
object UpdateAnnotationStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateAnnotationStoreResponse =
      zio.aws.omics.model.UpdateAnnotationStoreResponse(
        creationTime,
        description,
        id,
        name,
        reference.asEditable,
        status,
        storeFormat.map(value => value),
        storeOptions.map(value => value.asEditable),
        updateTime
      )
    def creationTime: CreationTime
    def description: StoreDescription
    def id: ResourceId
    def name: String
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def status: zio.aws.omics.model.StoreStatus
    def storeFormat: Optional[zio.aws.omics.model.StoreFormat]
    def storeOptions: Optional[zio.aws.omics.model.StoreOptions.ReadOnly]
    def updateTime: UpdateTime
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, Nothing, StoreDescription] =
      ZIO.succeed(description)
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getStoreFormat: ZIO[Any, AwsError, zio.aws.omics.model.StoreFormat] =
      AwsError.unwrapOptionField("storeFormat", storeFormat)
    def getStoreOptions
        : ZIO[Any, AwsError, zio.aws.omics.model.StoreOptions.ReadOnly] =
      AwsError.unwrapOptionField("storeOptions", storeOptions)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
  ) extends zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly {
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val description: StoreDescription =
      zio.aws.omics.model.primitives.StoreDescription(impl.description())
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val name: String = impl.name(): String
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val storeFormat: Optional[zio.aws.omics.model.StoreFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeFormat())
        .map(value => zio.aws.omics.model.StoreFormat.wrap(value))
    override val storeOptions
        : Optional[zio.aws.omics.model.StoreOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storeOptions())
        .map(value => zio.aws.omics.model.StoreOptions.wrap(value))
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse
  ): zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly = new Wrapper(
    impl
  )
}
