package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  UpdateRunGroupRequestMaxCpusInteger,
  RunGroupName,
  RunGroupId,
  UpdateRunGroupRequestMaxRunsInteger,
  UpdateRunGroupRequestMaxDurationInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateRunGroupRequest(
    id: RunGroupId,
    maxCpus: Optional[UpdateRunGroupRequestMaxCpusInteger] = Optional.Absent,
    maxDuration: Optional[UpdateRunGroupRequestMaxDurationInteger] =
      Optional.Absent,
    maxRuns: Optional[UpdateRunGroupRequestMaxRunsInteger] = Optional.Absent,
    name: Optional[RunGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest = {
    import UpdateRunGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest
      .builder()
      .id(RunGroupId.unwrap(id): java.lang.String)
      .optionallyWith(
        maxCpus.map(value =>
          UpdateRunGroupRequestMaxCpusInteger.unwrap(value): Integer
        )
      )(_.maxCpus)
      .optionallyWith(
        maxDuration.map(value =>
          UpdateRunGroupRequestMaxDurationInteger.unwrap(value): Integer
        )
      )(_.maxDuration)
      .optionallyWith(
        maxRuns.map(value =>
          UpdateRunGroupRequestMaxRunsInteger.unwrap(value): Integer
        )
      )(_.maxRuns)
      .optionallyWith(
        name.map(value => RunGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateRunGroupRequest.ReadOnly =
    zio.aws.omics.model.UpdateRunGroupRequest.wrap(buildAwsValue())
}
object UpdateRunGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateRunGroupRequest =
      zio.aws.omics.model.UpdateRunGroupRequest(
        id,
        maxCpus.map(value => value),
        maxDuration.map(value => value),
        maxRuns.map(value => value),
        name.map(value => value)
      )
    def id: RunGroupId
    def maxCpus: Optional[UpdateRunGroupRequestMaxCpusInteger]
    def maxDuration: Optional[UpdateRunGroupRequestMaxDurationInteger]
    def maxRuns: Optional[UpdateRunGroupRequestMaxRunsInteger]
    def name: Optional[RunGroupName]
    def getId: ZIO[Any, Nothing, RunGroupId] = ZIO.succeed(id)
    def getMaxCpus: ZIO[Any, AwsError, UpdateRunGroupRequestMaxCpusInteger] =
      AwsError.unwrapOptionField("maxCpus", maxCpus)
    def getMaxDuration
        : ZIO[Any, AwsError, UpdateRunGroupRequestMaxDurationInteger] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getMaxRuns: ZIO[Any, AwsError, UpdateRunGroupRequestMaxRunsInteger] =
      AwsError.unwrapOptionField("maxRuns", maxRuns)
    def getName: ZIO[Any, AwsError, RunGroupName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest
  ) extends zio.aws.omics.model.UpdateRunGroupRequest.ReadOnly {
    override val id: RunGroupId =
      zio.aws.omics.model.primitives.RunGroupId(impl.id())
    override val maxCpus: Optional[UpdateRunGroupRequestMaxCpusInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxCpus())
        .map(value =>
          zio.aws.omics.model.primitives
            .UpdateRunGroupRequestMaxCpusInteger(value)
        )
    override val maxDuration
        : Optional[UpdateRunGroupRequestMaxDurationInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxDuration())
        .map(value =>
          zio.aws.omics.model.primitives
            .UpdateRunGroupRequestMaxDurationInteger(value)
        )
    override val maxRuns: Optional[UpdateRunGroupRequestMaxRunsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRuns())
        .map(value =>
          zio.aws.omics.model.primitives
            .UpdateRunGroupRequestMaxRunsInteger(value)
        )
    override val name: Optional[RunGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.RunGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest
  ): zio.aws.omics.model.UpdateRunGroupRequest.ReadOnly = new Wrapper(impl)
}
