package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.StoreDescription
import scala.jdk.CollectionConverters._
final case class UpdateVariantStoreRequest(
    description: Optional[StoreDescription] = Optional.Absent,
    name: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest = {
    import UpdateVariantStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          StoreDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateVariantStoreRequest.ReadOnly =
    zio.aws.omics.model.UpdateVariantStoreRequest.wrap(buildAwsValue())
}
object UpdateVariantStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateVariantStoreRequest =
      zio.aws.omics.model
        .UpdateVariantStoreRequest(description.map(value => value), name)
    def description: Optional[StoreDescription]
    def name: String
    def getDescription: ZIO[Any, AwsError, StoreDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
  ) extends zio.aws.omics.model.UpdateVariantStoreRequest.ReadOnly {
    override val description: Optional[StoreDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.omics.model.primitives.StoreDescription(value))
    override val name: String = impl.name(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest
  ): zio.aws.omics.model.UpdateVariantStoreRequest.ReadOnly = new Wrapper(impl)
}
