package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  WorkflowName,
  WorkflowId,
  WorkflowDescription
}
import scala.jdk.CollectionConverters._
final case class UpdateWorkflowRequest(
    description: Optional[WorkflowDescription] = Optional.Absent,
    id: WorkflowId,
    name: Optional[WorkflowName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest = {
    import UpdateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .id(WorkflowId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateWorkflowRequest.ReadOnly =
    zio.aws.omics.model.UpdateWorkflowRequest.wrap(buildAwsValue())
}
object UpdateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateWorkflowRequest =
      zio.aws.omics.model.UpdateWorkflowRequest(
        description.map(value => value),
        id,
        name.map(value => value)
      )
    def description: Optional[WorkflowDescription]
    def id: WorkflowId
    def name: Optional[WorkflowName]
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
  ) extends zio.aws.omics.model.UpdateWorkflowRequest.ReadOnly {
    override val description: Optional[WorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.WorkflowDescription(value))
    override val id: WorkflowId =
      zio.aws.omics.model.primitives.WorkflowId(impl.id())
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
  ): zio.aws.omics.model.UpdateWorkflowRequest.ReadOnly = new Wrapper(impl)
}
