package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{JobStatusMsg, S3Uri}
import scala.jdk.CollectionConverters._
final case class VariantImportItemDetail(
    jobStatus: zio.aws.omics.model.JobStatus,
    source: S3Uri,
    statusMessage: Optional[JobStatusMsg] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.VariantImportItemDetail = {
    import VariantImportItemDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.VariantImportItemDetail
      .builder()
      .jobStatus(jobStatus.unwrap)
      .source(S3Uri.unwrap(source): java.lang.String)
      .optionallyWith(
        statusMessage.map(value => JobStatusMsg.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.VariantImportItemDetail.ReadOnly =
    zio.aws.omics.model.VariantImportItemDetail.wrap(buildAwsValue())
}
object VariantImportItemDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.VariantImportItemDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.VariantImportItemDetail =
      zio.aws.omics.model.VariantImportItemDetail(
        jobStatus,
        source,
        statusMessage.map(value => value)
      )
    def jobStatus: zio.aws.omics.model.JobStatus
    def source: S3Uri
    def statusMessage: Optional[JobStatusMsg]
    def getJobStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(jobStatus)
    def getSource: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(source)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMsg] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.VariantImportItemDetail
  ) extends zio.aws.omics.model.VariantImportItemDetail.ReadOnly {
    override val jobStatus: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.jobStatus())
    override val source: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.source())
    override val statusMessage: Optional[JobStatusMsg] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.omics.model.primitives.JobStatusMsg(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.VariantImportItemDetail
  ): zio.aws.omics.model.VariantImportItemDetail.ReadOnly = new Wrapper(impl)
}
