package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  CompletionTime,
  Arn,
  RunLeftNormalization
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VariantImportJobItem(
    completionTime: Optional[CompletionTime] = Optional.Absent,
    creationTime: CreationTime,
    destinationName: String,
    id: String,
    roleArn: Arn,
    runLeftNormalization: Optional[RunLeftNormalization] = Optional.Absent,
    status: zio.aws.omics.model.JobStatus,
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.VariantImportJobItem = {
    import VariantImportJobItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.VariantImportJobItem
      .builder()
      .optionallyWith(
        completionTime.map(value => CompletionTime.unwrap(value): Instant)
      )(_.completionTime)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .destinationName(destinationName: java.lang.String)
      .id(id: java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        runLeftNormalization.map(value =>
          RunLeftNormalization.unwrap(value): java.lang.Boolean
        )
      )(_.runLeftNormalization)
      .status(status.unwrap)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.VariantImportJobItem.ReadOnly =
    zio.aws.omics.model.VariantImportJobItem.wrap(buildAwsValue())
}
object VariantImportJobItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.VariantImportJobItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.VariantImportJobItem =
      zio.aws.omics.model.VariantImportJobItem(
        completionTime.map(value => value),
        creationTime,
        destinationName,
        id,
        roleArn,
        runLeftNormalization.map(value => value),
        status,
        updateTime
      )
    def completionTime: Optional[CompletionTime]
    def creationTime: CreationTime
    def destinationName: String
    def id: String
    def roleArn: Arn
    def runLeftNormalization: Optional[RunLeftNormalization]
    def status: zio.aws.omics.model.JobStatus
    def updateTime: UpdateTime
    def getCompletionTime: ZIO[Any, AwsError, CompletionTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getDestinationName: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationName)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getRunLeftNormalization: ZIO[Any, AwsError, RunLeftNormalization] =
      AwsError.unwrapOptionField("runLeftNormalization", runLeftNormalization)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(status)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.VariantImportJobItem
  ) extends zio.aws.omics.model.VariantImportJobItem.ReadOnly {
    override val completionTime: Optional[CompletionTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value => zio.aws.omics.model.primitives.CompletionTime(value))
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val destinationName: String = impl.destinationName(): String
    override val id: String = impl.id(): String
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val runLeftNormalization: Optional[RunLeftNormalization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runLeftNormalization())
        .map(value =>
          zio.aws.omics.model.primitives.RunLeftNormalization(value)
        )
    override val status: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.status())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.VariantImportJobItem
  ): zio.aws.omics.model.VariantImportJobItem.ReadOnly = new Wrapper(impl)
}
