package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VcfOptions(
    ignoreFilterField: Optional[Boolean] = Optional.Absent,
    ignoreQualField: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.VcfOptions = {
    import VcfOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.VcfOptions
      .builder()
      .optionallyWith(ignoreFilterField.map(value => value: java.lang.Boolean))(
        _.ignoreFilterField
      )
      .optionallyWith(ignoreQualField.map(value => value: java.lang.Boolean))(
        _.ignoreQualField
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.VcfOptions.ReadOnly =
    zio.aws.omics.model.VcfOptions.wrap(buildAwsValue())
}
object VcfOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.VcfOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.VcfOptions =
      zio.aws.omics.model.VcfOptions(
        ignoreFilterField.map(value => value),
        ignoreQualField.map(value => value)
      )
    def ignoreFilterField: Optional[Boolean]
    def ignoreQualField: Optional[Boolean]
    def getIgnoreFilterField: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignoreFilterField", ignoreFilterField)
    def getIgnoreQualField: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignoreQualField", ignoreQualField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.VcfOptions
  ) extends zio.aws.omics.model.VcfOptions.ReadOnly {
    override val ignoreFilterField: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ignoreFilterField())
      .map(value => value: Boolean)
    override val ignoreQualField: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ignoreQualField())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.VcfOptions
  ): zio.aws.omics.model.VcfOptions.ReadOnly = new Wrapper(impl)
}
