package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.WorkflowParameterDescription
import scala.jdk.CollectionConverters._
final case class WorkflowParameter(
    description: Optional[WorkflowParameterDescription] = Optional.Absent,
    optional: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.WorkflowParameter = {
    import WorkflowParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.WorkflowParameter
      .builder()
      .optionallyWith(
        description.map(value =>
          WorkflowParameterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(optional.map(value => value: java.lang.Boolean))(
        _.optional
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.WorkflowParameter.ReadOnly =
    zio.aws.omics.model.WorkflowParameter.wrap(buildAwsValue())
}
object WorkflowParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.WorkflowParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.WorkflowParameter =
      zio.aws.omics.model.WorkflowParameter(
        description.map(value => value),
        optional.map(value => value)
      )
    def description: Optional[WorkflowParameterDescription]
    def optional: Optional[Boolean]
    def getDescription: ZIO[Any, AwsError, WorkflowParameterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOptional: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("optional", optional)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.WorkflowParameter
  ) extends zio.aws.omics.model.WorkflowParameter.ReadOnly {
    override val description: Optional[WorkflowParameterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.omics.model.primitives.WorkflowParameterDescription(value)
        )
    override val optional: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.optional())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.WorkflowParameter
  ): zio.aws.omics.model.WorkflowParameter.ReadOnly = new Wrapper(impl)
}
