package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowStatus {
  def unwrap: software.amazon.awssdk.services.omics.model.WorkflowStatus
}
object WorkflowStatus {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.WorkflowStatus
  ): zio.aws.omics.model.WorkflowStatus = value match {
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.omics.model.WorkflowStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.CREATING
  }
  case object ACTIVE extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.UPDATING
  }
  case object DELETED extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.DELETED
  }
  case object FAILED extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.FAILED
  }
  case object INACTIVE extends zio.aws.omics.model.WorkflowStatus {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowStatus =
      software.amazon.awssdk.services.omics.model.WorkflowStatus.INACTIVE
  }
}
