package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowType {
  def unwrap: software.amazon.awssdk.services.omics.model.WorkflowType
}
object WorkflowType {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.WorkflowType
  ): zio.aws.omics.model.WorkflowType = value match {
    case software.amazon.awssdk.services.omics.model.WorkflowType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.WorkflowType.PRIVATE =>
      val r = PRIVATE
      r
    case software.amazon.awssdk.services.omics.model.WorkflowType.SERVICE =>
      val r = SERVICE
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowType =
      software.amazon.awssdk.services.omics.model.WorkflowType.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIVATE extends zio.aws.omics.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowType =
      software.amazon.awssdk.services.omics.model.WorkflowType.PRIVATE
  }
  case object SERVICE extends zio.aws.omics.model.WorkflowType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowType =
      software.amazon.awssdk.services.omics.model.WorkflowType.SERVICE
  }
}
