package zio.aws.omics
import zio.aws.omics.model.primitives.RunGroupId.Type
import zio.aws.omics.model.primitives.{
  TagValue,
  SchemaItemKeyString,
  RunResourceDigest,
  ResourceIdentifier,
  WorkflowParameterName,
  RunResourceDigestKey,
  FormatToHeaderValueString,
  ReadSetId,
  TagKey
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import software.amazon.awssdk.core.document.Document
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActivationJobId extends Subtype[String]
    type ActivationJobId = zio.aws.omics.model.primitives.ActivationJobId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.omics.model.primitives.Arn.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.omics.model.primitives.Blob.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.omics.model.primitives.ClientToken.Type
    object CommentChar extends Subtype[String]
    type CommentChar = zio.aws.omics.model.primitives.CommentChar.Type
    object CompletionTime extends Subtype[Instant]
    type CompletionTime = zio.aws.omics.model.primitives.CompletionTime.Type
    object CreateAnnotationStoreRequestNameString extends Subtype[String]
    type CreateAnnotationStoreRequestNameString =
      zio.aws.omics.model.primitives.CreateAnnotationStoreRequestNameString.Type
    object CreateRunGroupRequestMaxCpusInteger extends Subtype[Int]
    type CreateRunGroupRequestMaxCpusInteger =
      zio.aws.omics.model.primitives.CreateRunGroupRequestMaxCpusInteger.Type
    object CreateRunGroupRequestMaxDurationInteger extends Subtype[Int]
    type CreateRunGroupRequestMaxDurationInteger =
      zio.aws.omics.model.primitives.CreateRunGroupRequestMaxDurationInteger.Type
    object CreateRunGroupRequestMaxRunsInteger extends Subtype[Int]
    type CreateRunGroupRequestMaxRunsInteger =
      zio.aws.omics.model.primitives.CreateRunGroupRequestMaxRunsInteger.Type
    object CreateVariantStoreRequestNameString extends Subtype[String]
    type CreateVariantStoreRequestNameString =
      zio.aws.omics.model.primitives.CreateVariantStoreRequestNameString.Type
    object CreateWorkflowRequestStorageCapacityInteger extends Subtype[Int]
    type CreateWorkflowRequestStorageCapacityInteger =
      zio.aws.omics.model.primitives.CreateWorkflowRequestStorageCapacityInteger.Type
    object CreationTime extends Subtype[Instant]
    type CreationTime = zio.aws.omics.model.primitives.CreationTime.Type
    object Encoding extends Subtype[String]
    type Encoding = zio.aws.omics.model.primitives.Encoding.Type
    object EscapeChar extends Subtype[String]
    type EscapeChar = zio.aws.omics.model.primitives.EscapeChar.Type
    object EscapeQuotes extends Subtype[Boolean]
    type EscapeQuotes = zio.aws.omics.model.primitives.EscapeQuotes.Type
    object ExportJobId extends Subtype[String]
    type ExportJobId = zio.aws.omics.model.primitives.ExportJobId.Type
    object FileInformationContentLengthLong extends Subtype[Long]
    type FileInformationContentLengthLong =
      zio.aws.omics.model.primitives.FileInformationContentLengthLong.Type
    object FileInformationPartSizeLong extends Subtype[Long]
    type FileInformationPartSizeLong =
      zio.aws.omics.model.primitives.FileInformationPartSizeLong.Type
    object FileInformationTotalPartsInteger extends Subtype[Int]
    type FileInformationTotalPartsInteger =
      zio.aws.omics.model.primitives.FileInformationTotalPartsInteger.Type
    object FormatToHeaderValueString extends Subtype[String]
    type FormatToHeaderValueString =
      zio.aws.omics.model.primitives.FormatToHeaderValueString.Type
    object GeneratedFrom extends Subtype[String]
    type GeneratedFrom = zio.aws.omics.model.primitives.GeneratedFrom.Type
    object GetReadSetRequestPartNumberInteger extends Subtype[Int]
    type GetReadSetRequestPartNumberInteger =
      zio.aws.omics.model.primitives.GetReadSetRequestPartNumberInteger.Type
    object GetReferenceRequestPartNumberInteger extends Subtype[Int]
    type GetReferenceRequestPartNumberInteger =
      zio.aws.omics.model.primitives.GetReferenceRequestPartNumberInteger.Type
    object GetRunGroupResponseMaxCpusInteger extends Subtype[Int]
    type GetRunGroupResponseMaxCpusInteger =
      zio.aws.omics.model.primitives.GetRunGroupResponseMaxCpusInteger.Type
    object GetRunGroupResponseMaxDurationInteger extends Subtype[Int]
    type GetRunGroupResponseMaxDurationInteger =
      zio.aws.omics.model.primitives.GetRunGroupResponseMaxDurationInteger.Type
    object GetRunGroupResponseMaxRunsInteger extends Subtype[Int]
    type GetRunGroupResponseMaxRunsInteger =
      zio.aws.omics.model.primitives.GetRunGroupResponseMaxRunsInteger.Type
    object GetRunResponsePriorityInteger extends Subtype[Int]
    type GetRunResponsePriorityInteger =
      zio.aws.omics.model.primitives.GetRunResponsePriorityInteger.Type
    object GetRunResponseStorageCapacityInteger extends Subtype[Int]
    type GetRunResponseStorageCapacityInteger =
      zio.aws.omics.model.primitives.GetRunResponseStorageCapacityInteger.Type
    object GetRunTaskResponseCpusInteger extends Subtype[Int]
    type GetRunTaskResponseCpusInteger =
      zio.aws.omics.model.primitives.GetRunTaskResponseCpusInteger.Type
    object GetRunTaskResponseMemoryInteger extends Subtype[Int]
    type GetRunTaskResponseMemoryInteger =
      zio.aws.omics.model.primitives.GetRunTaskResponseMemoryInteger.Type
    object GetWorkflowResponseStorageCapacityInteger extends Subtype[Int]
    type GetWorkflowResponseStorageCapacityInteger =
      zio.aws.omics.model.primitives.GetWorkflowResponseStorageCapacityInteger.Type
    object Header extends Subtype[Boolean]
    type Header = zio.aws.omics.model.primitives.Header.Type
    object ImportJobId extends Subtype[String]
    type ImportJobId = zio.aws.omics.model.primitives.ImportJobId.Type
    object JobStatusMessage extends Subtype[String]
    type JobStatusMessage = zio.aws.omics.model.primitives.JobStatusMessage.Type
    object JobStatusMsg extends Subtype[String]
    type JobStatusMsg = zio.aws.omics.model.primitives.JobStatusMsg.Type
    object LineSep extends Subtype[String]
    type LineSep = zio.aws.omics.model.primitives.LineSep.Type
    object ListAnnotationImportJobsRequestMaxResultsInteger extends Subtype[Int]
    type ListAnnotationImportJobsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListAnnotationImportJobsRequestMaxResultsInteger.Type
    object ListAnnotationImportJobsRequestNextTokenString
        extends Subtype[String]
    type ListAnnotationImportJobsRequestNextTokenString =
      zio.aws.omics.model.primitives.ListAnnotationImportJobsRequestNextTokenString.Type
    object ListAnnotationStoresRequestMaxResultsInteger extends Subtype[Int]
    type ListAnnotationStoresRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListAnnotationStoresRequestMaxResultsInteger.Type
    object ListAnnotationStoresRequestNextTokenString extends Subtype[String]
    type ListAnnotationStoresRequestNextTokenString =
      zio.aws.omics.model.primitives.ListAnnotationStoresRequestNextTokenString.Type
    object ListReadSetActivationJobsRequestMaxResultsInteger
        extends Subtype[Int]
    type ListReadSetActivationJobsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReadSetActivationJobsRequestMaxResultsInteger.Type
    object ListReadSetExportJobsRequestMaxResultsInteger extends Subtype[Int]
    type ListReadSetExportJobsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReadSetExportJobsRequestMaxResultsInteger.Type
    object ListReadSetImportJobsRequestMaxResultsInteger extends Subtype[Int]
    type ListReadSetImportJobsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReadSetImportJobsRequestMaxResultsInteger.Type
    object ListReadSetsRequestMaxResultsInteger extends Subtype[Int]
    type ListReadSetsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReadSetsRequestMaxResultsInteger.Type
    object ListReferenceImportJobsRequestMaxResultsInteger extends Subtype[Int]
    type ListReferenceImportJobsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReferenceImportJobsRequestMaxResultsInteger.Type
    object ListReferenceStoresRequestMaxResultsInteger extends Subtype[Int]
    type ListReferenceStoresRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReferenceStoresRequestMaxResultsInteger.Type
    object ListReferencesRequestMaxResultsInteger extends Subtype[Int]
    type ListReferencesRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListReferencesRequestMaxResultsInteger.Type
    object ListRunGroupsRequestMaxResultsInteger extends Subtype[Int]
    type ListRunGroupsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListRunGroupsRequestMaxResultsInteger.Type
    object ListRunTasksRequestMaxResultsInteger extends Subtype[Int]
    type ListRunTasksRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListRunTasksRequestMaxResultsInteger.Type
    object ListRunsRequestMaxResultsInteger extends Subtype[Int]
    type ListRunsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListRunsRequestMaxResultsInteger.Type
    object ListSequenceStoresRequestMaxResultsInteger extends Subtype[Int]
    type ListSequenceStoresRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListSequenceStoresRequestMaxResultsInteger.Type
    object ListVariantImportJobsRequestMaxResultsInteger extends Subtype[Int]
    type ListVariantImportJobsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListVariantImportJobsRequestMaxResultsInteger.Type
    object ListVariantImportJobsRequestNextTokenString extends Subtype[String]
    type ListVariantImportJobsRequestNextTokenString =
      zio.aws.omics.model.primitives.ListVariantImportJobsRequestNextTokenString.Type
    object ListVariantStoresRequestMaxResultsInteger extends Subtype[Int]
    type ListVariantStoresRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListVariantStoresRequestMaxResultsInteger.Type
    object ListVariantStoresRequestNextTokenString extends Subtype[String]
    type ListVariantStoresRequestNextTokenString =
      zio.aws.omics.model.primitives.ListVariantStoresRequestNextTokenString.Type
    object ListWorkflowsRequestMaxResultsInteger extends Subtype[Int]
    type ListWorkflowsRequestMaxResultsInteger =
      zio.aws.omics.model.primitives.ListWorkflowsRequestMaxResultsInteger.Type
    object Md5 extends Subtype[String]
    type Md5 = zio.aws.omics.model.primitives.Md5.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.omics.model.primitives.NextToken.Type
    object PrimitiveBoolean extends Subtype[Boolean]
    type PrimitiveBoolean = zio.aws.omics.model.primitives.PrimitiveBoolean.Type
    object Quote extends Subtype[String]
    type Quote = zio.aws.omics.model.primitives.Quote.Type
    object QuoteAll extends Subtype[Boolean]
    type QuoteAll = zio.aws.omics.model.primitives.QuoteAll.Type
    object Range extends Subtype[String]
    type Range = zio.aws.omics.model.primitives.Range.Type
    object ReadSetArn extends Subtype[String]
    type ReadSetArn = zio.aws.omics.model.primitives.ReadSetArn.Type
    object ReadSetDescription extends Subtype[String]
    type ReadSetDescription =
      zio.aws.omics.model.primitives.ReadSetDescription.Type
    object ReadSetId extends Subtype[String]
    type ReadSetId = zio.aws.omics.model.primitives.ReadSetId.Type
    object ReadSetName extends Subtype[String]
    type ReadSetName = zio.aws.omics.model.primitives.ReadSetName.Type
    object ReadSetStreamingBlob extends Subtype[Chunk[Byte]]
    type ReadSetStreamingBlob =
      zio.aws.omics.model.primitives.ReadSetStreamingBlob.Type
    object ReferenceArn extends Subtype[String]
    type ReferenceArn = zio.aws.omics.model.primitives.ReferenceArn.Type
    object ReferenceDescription extends Subtype[String]
    type ReferenceDescription =
      zio.aws.omics.model.primitives.ReferenceDescription.Type
    object ReferenceId extends Subtype[String]
    type ReferenceId = zio.aws.omics.model.primitives.ReferenceId.Type
    object ReferenceName extends Subtype[String]
    type ReferenceName = zio.aws.omics.model.primitives.ReferenceName.Type
    object ReferenceStoreArn extends Subtype[String]
    type ReferenceStoreArn =
      zio.aws.omics.model.primitives.ReferenceStoreArn.Type
    object ReferenceStoreDescription extends Subtype[String]
    type ReferenceStoreDescription =
      zio.aws.omics.model.primitives.ReferenceStoreDescription.Type
    object ReferenceStoreId extends Subtype[String]
    type ReferenceStoreId = zio.aws.omics.model.primitives.ReferenceStoreId.Type
    object ReferenceStoreName extends Subtype[String]
    type ReferenceStoreName =
      zio.aws.omics.model.primitives.ReferenceStoreName.Type
    object ReferenceStreamingBlob extends Subtype[Chunk[Byte]]
    type ReferenceStreamingBlob =
      zio.aws.omics.model.primitives.ReferenceStreamingBlob.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.omics.model.primitives.ResourceId.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.omics.model.primitives.ResourceIdentifier.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.omics.model.primitives.RoleArn.Type
    object RunArn extends Subtype[String]
    type RunArn = zio.aws.omics.model.primitives.RunArn.Type
    object RunGroupArn extends Subtype[String]
    type RunGroupArn = zio.aws.omics.model.primitives.RunGroupArn.Type
    object RunGroupId extends Subtype[String]
    type RunGroupId = zio.aws.omics.model.primitives.RunGroupId.Type
    object RunGroupListItemMaxCpusInteger extends Subtype[Int]
    type RunGroupListItemMaxCpusInteger =
      zio.aws.omics.model.primitives.RunGroupListItemMaxCpusInteger.Type
    object RunGroupListItemMaxDurationInteger extends Subtype[Int]
    type RunGroupListItemMaxDurationInteger =
      zio.aws.omics.model.primitives.RunGroupListItemMaxDurationInteger.Type
    object RunGroupListItemMaxRunsInteger extends Subtype[Int]
    type RunGroupListItemMaxRunsInteger =
      zio.aws.omics.model.primitives.RunGroupListItemMaxRunsInteger.Type
    object RunGroupListToken extends Subtype[String]
    type RunGroupListToken =
      zio.aws.omics.model.primitives.RunGroupListToken.Type
    object RunGroupName extends Subtype[String]
    type RunGroupName = zio.aws.omics.model.primitives.RunGroupName.Type
    object RunGroupRequestId extends Subtype[String]
    type RunGroupRequestId =
      zio.aws.omics.model.primitives.RunGroupRequestId.Type
    object RunGroupTimestamp extends Subtype[Instant]
    type RunGroupTimestamp =
      zio.aws.omics.model.primitives.RunGroupTimestamp.Type
    object RunId extends Subtype[String]
    type RunId = zio.aws.omics.model.primitives.RunId.Type
    object RunLeftNormalization extends Subtype[Boolean]
    type RunLeftNormalization =
      zio.aws.omics.model.primitives.RunLeftNormalization.Type
    object RunListItemPriorityInteger extends Subtype[Int]
    type RunListItemPriorityInteger =
      zio.aws.omics.model.primitives.RunListItemPriorityInteger.Type
    object RunListItemStorageCapacityInteger extends Subtype[Int]
    type RunListItemStorageCapacityInteger =
      zio.aws.omics.model.primitives.RunListItemStorageCapacityInteger.Type
    object RunListToken extends Subtype[String]
    type RunListToken = zio.aws.omics.model.primitives.RunListToken.Type
    object RunName extends Subtype[String]
    type RunName = zio.aws.omics.model.primitives.RunName.Type
    object RunOutputUri extends Subtype[String]
    type RunOutputUri = zio.aws.omics.model.primitives.RunOutputUri.Type
    object RunRequestId extends Subtype[String]
    type RunRequestId = zio.aws.omics.model.primitives.RunRequestId.Type
    object RunResourceDigest extends Subtype[String]
    type RunResourceDigest =
      zio.aws.omics.model.primitives.RunResourceDigest.Type
    object RunResourceDigestKey extends Subtype[String]
    type RunResourceDigestKey =
      zio.aws.omics.model.primitives.RunResourceDigestKey.Type
    object RunRoleArn extends Subtype[String]
    type RunRoleArn = zio.aws.omics.model.primitives.RunRoleArn.Type
    object RunStartedBy extends Subtype[String]
    type RunStartedBy = zio.aws.omics.model.primitives.RunStartedBy.Type
    object RunStatusMessage extends Subtype[String]
    type RunStatusMessage = zio.aws.omics.model.primitives.RunStatusMessage.Type
    object RunTimestamp extends Subtype[Instant]
    type RunTimestamp = zio.aws.omics.model.primitives.RunTimestamp.Type
    object S3Destination extends Subtype[String]
    type S3Destination = zio.aws.omics.model.primitives.S3Destination.Type
    object S3Uri extends Subtype[String]
    type S3Uri = zio.aws.omics.model.primitives.S3Uri.Type
    object SampleId extends Subtype[String]
    type SampleId = zio.aws.omics.model.primitives.SampleId.Type
    object SchemaItemKeyString extends Subtype[String]
    type SchemaItemKeyString =
      zio.aws.omics.model.primitives.SchemaItemKeyString.Type
    object Separator extends Subtype[String]
    type Separator = zio.aws.omics.model.primitives.Separator.Type
    object SequenceStoreArn extends Subtype[String]
    type SequenceStoreArn = zio.aws.omics.model.primitives.SequenceStoreArn.Type
    object SequenceStoreDescription extends Subtype[String]
    type SequenceStoreDescription =
      zio.aws.omics.model.primitives.SequenceStoreDescription.Type
    object SequenceStoreId extends Subtype[String]
    type SequenceStoreId = zio.aws.omics.model.primitives.SequenceStoreId.Type
    object SequenceStoreName extends Subtype[String]
    type SequenceStoreName =
      zio.aws.omics.model.primitives.SequenceStoreName.Type
    object SseConfigKeyArnString extends Subtype[String]
    type SseConfigKeyArnString =
      zio.aws.omics.model.primitives.SseConfigKeyArnString.Type
    object StartRunRequestPriorityInteger extends Subtype[Int]
    type StartRunRequestPriorityInteger =
      zio.aws.omics.model.primitives.StartRunRequestPriorityInteger.Type
    object StartRunRequestStorageCapacityInteger extends Subtype[Int]
    type StartRunRequestStorageCapacityInteger =
      zio.aws.omics.model.primitives.StartRunRequestStorageCapacityInteger.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage = zio.aws.omics.model.primitives.StatusMessage.Type
    object StoreDescription extends Subtype[String]
    type StoreDescription = zio.aws.omics.model.primitives.StoreDescription.Type
    object StoreName extends Subtype[String]
    type StoreName = zio.aws.omics.model.primitives.StoreName.Type
    object SubjectId extends Subtype[String]
    type SubjectId = zio.aws.omics.model.primitives.SubjectId.Type
    object SyntheticTimestamp_date_time extends Subtype[Instant]
    type SyntheticTimestamp_date_time =
      zio.aws.omics.model.primitives.SyntheticTimestamp_date_time.Type
    object TagArn extends Subtype[String]
    type TagArn = zio.aws.omics.model.primitives.TagArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.omics.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.omics.model.primitives.TagValue.Type
    object TaskId extends Subtype[String]
    type TaskId = zio.aws.omics.model.primitives.TaskId.Type
    object TaskListItemCpusInteger extends Subtype[Int]
    type TaskListItemCpusInteger =
      zio.aws.omics.model.primitives.TaskListItemCpusInteger.Type
    object TaskListItemMemoryInteger extends Subtype[Int]
    type TaskListItemMemoryInteger =
      zio.aws.omics.model.primitives.TaskListItemMemoryInteger.Type
    object TaskListToken extends Subtype[String]
    type TaskListToken = zio.aws.omics.model.primitives.TaskListToken.Type
    object TaskLogStream extends Subtype[String]
    type TaskLogStream = zio.aws.omics.model.primitives.TaskLogStream.Type
    object TaskName extends Subtype[String]
    type TaskName = zio.aws.omics.model.primitives.TaskName.Type
    object TaskStatusMessage extends Subtype[String]
    type TaskStatusMessage =
      zio.aws.omics.model.primitives.TaskStatusMessage.Type
    object TaskTimestamp extends Subtype[Instant]
    type TaskTimestamp = zio.aws.omics.model.primitives.TaskTimestamp.Type
    object UpdateRunGroupRequestMaxCpusInteger extends Subtype[Int]
    type UpdateRunGroupRequestMaxCpusInteger =
      zio.aws.omics.model.primitives.UpdateRunGroupRequestMaxCpusInteger.Type
    object UpdateRunGroupRequestMaxDurationInteger extends Subtype[Int]
    type UpdateRunGroupRequestMaxDurationInteger =
      zio.aws.omics.model.primitives.UpdateRunGroupRequestMaxDurationInteger.Type
    object UpdateRunGroupRequestMaxRunsInteger extends Subtype[Int]
    type UpdateRunGroupRequestMaxRunsInteger =
      zio.aws.omics.model.primitives.UpdateRunGroupRequestMaxRunsInteger.Type
    object UpdateTime extends Subtype[Instant]
    type UpdateTime = zio.aws.omics.model.primitives.UpdateTime.Type
    object WorkflowArn extends Subtype[String]
    type WorkflowArn = zio.aws.omics.model.primitives.WorkflowArn.Type
    object WorkflowDefinition extends Subtype[String]
    type WorkflowDefinition =
      zio.aws.omics.model.primitives.WorkflowDefinition.Type
    object WorkflowDescription extends Subtype[String]
    type WorkflowDescription =
      zio.aws.omics.model.primitives.WorkflowDescription.Type
    object WorkflowDigest extends Subtype[String]
    type WorkflowDigest = zio.aws.omics.model.primitives.WorkflowDigest.Type
    object WorkflowId extends Subtype[String]
    type WorkflowId = zio.aws.omics.model.primitives.WorkflowId.Type
    object WorkflowListToken extends Subtype[String]
    type WorkflowListToken =
      zio.aws.omics.model.primitives.WorkflowListToken.Type
    object WorkflowMain extends Subtype[String]
    type WorkflowMain = zio.aws.omics.model.primitives.WorkflowMain.Type
    object WorkflowName extends Subtype[String]
    type WorkflowName = zio.aws.omics.model.primitives.WorkflowName.Type
    object WorkflowParameterDescription extends Subtype[String]
    type WorkflowParameterDescription =
      zio.aws.omics.model.primitives.WorkflowParameterDescription.Type
    object WorkflowParameterName extends Subtype[String]
    type WorkflowParameterName =
      zio.aws.omics.model.primitives.WorkflowParameterName.Type
    object WorkflowRequestId extends Subtype[String]
    type WorkflowRequestId =
      zio.aws.omics.model.primitives.WorkflowRequestId.Type
    object WorkflowStatusMessage extends Subtype[String]
    type WorkflowStatusMessage =
      zio.aws.omics.model.primitives.WorkflowStatusMessage.Type
    object WorkflowTimestamp extends Subtype[Instant]
    type WorkflowTimestamp =
      zio.aws.omics.model.primitives.WorkflowTimestamp.Type
  }
  type ActivateReadSetJobList = List[zio.aws.omics.model.ActivateReadSetJobItem]
  type ActivateReadSetSourceList =
    List[zio.aws.omics.model.ActivateReadSetSourceItem]
  type AnnotationImportItemDetails =
    List[zio.aws.omics.model.AnnotationImportItemDetail]
  type AnnotationImportItemSources =
    List[zio.aws.omics.model.AnnotationImportItemSource]
  type AnnotationImportJobItems =
    List[zio.aws.omics.model.AnnotationImportJobItem]
  type AnnotationStoreItems = List[zio.aws.omics.model.AnnotationStoreItem]
  type ExportReadSetDetailList = List[zio.aws.omics.model.ExportReadSetDetail]
  type ExportReadSetJobDetailList =
    List[zio.aws.omics.model.ExportReadSetJobDetail]
  type FormatToHeader =
    Map[zio.aws.omics.model.FormatToHeaderKey, FormatToHeaderValueString]
  type ImportReadSetJobList = List[zio.aws.omics.model.ImportReadSetJobItem]
  type ImportReadSetSourceList =
    List[zio.aws.omics.model.ImportReadSetSourceItem]
  type ImportReferenceJobList = List[zio.aws.omics.model.ImportReferenceJobItem]
  type ImportReferenceSourceList =
    List[zio.aws.omics.model.ImportReferenceSourceItem]
  type ListAnnotationImportJobsRequestIdsList = List[ResourceIdentifier]
  type ListAnnotationStoresRequestIdsList = List[ResourceIdentifier]
  type ListVariantImportJobsRequestIdsList = List[ResourceIdentifier]
  type ListVariantStoresRequestIdsList = List[ResourceIdentifier]
  type ReadSetBatchErrorList = List[zio.aws.omics.model.ReadSetBatchError]
  type ReadSetIdList = List[ReadSetId]
  type ReadSetList = List[zio.aws.omics.model.ReadSetListItem]
  type ReferenceList = List[zio.aws.omics.model.ReferenceListItem]
  type ReferenceStoreDetailList = List[zio.aws.omics.model.ReferenceStoreDetail]
  type RunExportList = List[zio.aws.omics.model.RunExport]
  type RunGroupList = List[zio.aws.omics.model.RunGroupListItem]
  type RunList = List[zio.aws.omics.model.RunListItem]
  type RunParameters = Document
  type RunResourceDigests = Map[RunResourceDigestKey, RunResourceDigest]
  type SchemaItem =
    Map[SchemaItemKeyString, zio.aws.omics.model.SchemaValueType]
  type SequenceStoreDetailList = List[zio.aws.omics.model.SequenceStoreDetail]
  type StartReadSetActivationJobRequestSourcesList =
    List[zio.aws.omics.model.StartReadSetActivationJobSourceItem]
  type StartReadSetExportJobRequestSourcesList =
    List[zio.aws.omics.model.ExportReadSet]
  type StartReadSetImportJobRequestSourcesList =
    List[zio.aws.omics.model.StartReadSetImportJobSourceItem]
  type StartReferenceImportJobRequestSourcesList =
    List[zio.aws.omics.model.StartReferenceImportJobSourceItem]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TagResourceRequestTagsMap = Map[TagKey, TagValue]
  type TaskList = List[zio.aws.omics.model.TaskListItem]
  type TsvStoreOptionsSchemaList =
    List[Map[SchemaItemKeyString, zio.aws.omics.model.SchemaValueType]]
  type VariantImportItemDetails =
    List[zio.aws.omics.model.VariantImportItemDetail]
  type VariantImportItemSources =
    List[zio.aws.omics.model.VariantImportItemSource]
  type VariantImportJobItems = List[zio.aws.omics.model.VariantImportJobItem]
  type VariantStoreItems = List[zio.aws.omics.model.VariantStoreItem]
  type WorkflowExportList = List[zio.aws.omics.model.WorkflowExport]
  type WorkflowList = List[zio.aws.omics.model.WorkflowListItem]
  type WorkflowParameterTemplate =
    Map[WorkflowParameterName, zio.aws.omics.model.WorkflowParameter]
}
