package zio.aws.omics
import zio.aws.omics.model.ListReadSetUploadPartsResponse.ReadOnly
import zio.aws.omics.model.{
  UpdateVariantStoreRequest,
  ListMultipartReadSetUploadsRequest,
  GetAnnotationStoreRequest,
  GetReadSetImportJobRequest,
  CreateWorkflowRequest,
  ListReferenceStoresRequest,
  CreateAnnotationStoreRequest,
  ListVariantStoresRequest,
  StartReferenceImportJobRequest,
  CreateRunGroupRequest,
  ListSequenceStoresRequest,
  GetVariantImportJobRequest,
  ListReadSetsRequest,
  UpdateWorkflowRequest,
  StartRunRequest,
  GetAnnotationImportJobRequest,
  CreateMultipartReadSetUploadRequest,
  DeleteVariantStoreRequest,
  GetReadSetActivationJobRequest,
  DeleteAnnotationStoreRequest,
  GetRunRequest,
  CreateSequenceStoreRequest,
  ListWorkflowsRequest,
  StartAnnotationImportJobRequest,
  GetReadSetMetadataRequest,
  GetRunGroupRequest,
  CancelRunRequest,
  ListTagsForResourceRequest,
  ListReadSetUploadPartsRequest,
  ListRunsRequest,
  GetReadSetExportJobRequest,
  BatchDeleteReadSetRequest,
  CancelVariantImportJobRequest,
  DeleteRunRequest,
  GetReferenceRequest,
  StartReadSetImportJobRequest,
  CreateVariantStoreRequest,
  DeleteReferenceRequest,
  ListVariantImportJobsRequest,
  UpdateAnnotationStoreRequest,
  StartReadSetActivationJobRequest,
  GetSequenceStoreRequest,
  StartVariantImportJobRequest,
  CancelAnnotationImportJobRequest,
  CreateReferenceStoreRequest,
  GetRunTaskRequest,
  ListRunTasksRequest,
  ListAnnotationStoresRequest,
  ListReferenceImportJobsRequest,
  DeleteReferenceStoreRequest,
  UntagResourceRequest,
  StartReadSetExportJobRequest,
  GetReferenceStoreRequest,
  GetVariantStoreRequest,
  ListReferencesRequest,
  ListReadSetImportJobsRequest,
  DeleteRunGroupRequest,
  GetReadSetRequest,
  ListReadSetActivationJobsRequest,
  UploadReadSetPartRequest,
  GetReferenceImportJobRequest,
  ListReadSetExportJobsRequest,
  DeleteSequenceStoreRequest,
  GetReferenceMetadataRequest,
  ListRunGroupsRequest,
  ListAnnotationImportJobsRequest,
  AbortMultipartReadSetUploadRequest,
  DeleteWorkflowRequest,
  CompleteMultipartReadSetUploadRequest,
  TagResourceRequest,
  UpdateRunGroupRequest,
  GetWorkflowRequest
}
import software.amazon.awssdk.services.omics.OmicsAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object OmicsMock extends Mock[Omics] {
  object CreateAnnotationStore
      extends Effect[
        CreateAnnotationStoreRequest,
        AwsError,
        zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly
      ]
  object StartReferenceImportJob
      extends Effect[
        StartReferenceImportJobRequest,
        AwsError,
        zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly
      ]
  object ListAnnotationStores
      extends Stream[
        ListAnnotationStoresRequest,
        AwsError,
        zio.aws.omics.model.AnnotationStoreItem.ReadOnly
      ]
  object ListAnnotationStoresPaginated
      extends Effect[
        ListAnnotationStoresRequest,
        AwsError,
        zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly
      ]
  object StartAnnotationImportJob
      extends Effect[
        StartAnnotationImportJobRequest,
        AwsError,
        zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly
      ]
  object GetAnnotationImportJob
      extends Effect[
        GetAnnotationImportJobRequest,
        AwsError,
        zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly
      ]
  object CreateSequenceStore
      extends Effect[
        CreateSequenceStoreRequest,
        AwsError,
        zio.aws.omics.model.CreateSequenceStoreResponse.ReadOnly
      ]
  object GetReadSetImportJob
      extends Effect[
        GetReadSetImportJobRequest,
        AwsError,
        zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly
      ]
  object GetReferenceStore
      extends Effect[
        GetReferenceStoreRequest,
        AwsError,
        zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly
      ]
  object UpdateRunGroup extends Effect[UpdateRunGroupRequest, AwsError, Unit]
  object ListVariantStores
      extends Stream[
        ListVariantStoresRequest,
        AwsError,
        zio.aws.omics.model.VariantStoreItem.ReadOnly
      ]
  object ListVariantStoresPaginated
      extends Effect[
        ListVariantStoresRequest,
        AwsError,
        zio.aws.omics.model.ListVariantStoresResponse.ReadOnly
      ]
  object ListReferenceImportJobs
      extends Stream[
        ListReferenceImportJobsRequest,
        AwsError,
        zio.aws.omics.model.ImportReferenceJobItem.ReadOnly
      ]
  object ListReferenceImportJobsPaginated
      extends Effect[
        ListReferenceImportJobsRequest,
        AwsError,
        zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly
      ]
  object GetVariantStore
      extends Effect[
        GetVariantStoreRequest,
        AwsError,
        zio.aws.omics.model.GetVariantStoreResponse.ReadOnly
      ]
  object StartReadSetImportJob
      extends Effect[
        StartReadSetImportJobRequest,
        AwsError,
        zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly
      ]
  object AbortMultipartReadSetUpload
      extends Effect[
        AbortMultipartReadSetUploadRequest,
        AwsError,
        zio.aws.omics.model.AbortMultipartReadSetUploadResponse.ReadOnly
      ]
  object ListReferenceStores
      extends Stream[
        ListReferenceStoresRequest,
        AwsError,
        zio.aws.omics.model.ReferenceStoreDetail.ReadOnly
      ]
  object ListReferenceStoresPaginated
      extends Effect[
        ListReferenceStoresRequest,
        AwsError,
        zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly
      ]
  object GetRun
      extends Effect[
        GetRunRequest,
        AwsError,
        zio.aws.omics.model.GetRunResponse.ReadOnly
      ]
  object DeleteAnnotationStore
      extends Effect[
        DeleteAnnotationStoreRequest,
        AwsError,
        zio.aws.omics.model.DeleteAnnotationStoreResponse.ReadOnly
      ]
  object DeleteReference
      extends Effect[
        DeleteReferenceRequest,
        AwsError,
        zio.aws.omics.model.DeleteReferenceResponse.ReadOnly
      ]
  object StartReadSetExportJob
      extends Effect[
        StartReadSetExportJobRequest,
        AwsError,
        zio.aws.omics.model.StartReadSetExportJobResponse.ReadOnly
      ]
  object GetReadSetExportJob
      extends Effect[
        GetReadSetExportJobRequest,
        AwsError,
        zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly
      ]
  object GetReference
      extends Effect[GetReferenceRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.omics.model.GetReferenceResponse.ReadOnly,
        Byte
      ]]
  object GetRunGroup
      extends Effect[
        GetRunGroupRequest,
        AwsError,
        zio.aws.omics.model.GetRunGroupResponse.ReadOnly
      ]
  object ListAnnotationImportJobs
      extends Stream[
        ListAnnotationImportJobsRequest,
        AwsError,
        zio.aws.omics.model.AnnotationImportJobItem.ReadOnly
      ]
  object ListAnnotationImportJobsPaginated
      extends Effect[
        ListAnnotationImportJobsRequest,
        AwsError,
        zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly
      ]
  object StartVariantImportJob
      extends Effect[
        StartVariantImportJobRequest,
        AwsError,
        zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly
      ]
  object CancelRun extends Effect[CancelRunRequest, AwsError, Unit]
  object UploadReadSetPart
      extends Effect[
        Tuple2[UploadReadSetPartRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.omics.model.UploadReadSetPartResponse.ReadOnly
      ]
  object ListSequenceStores
      extends Stream[
        ListSequenceStoresRequest,
        AwsError,
        zio.aws.omics.model.SequenceStoreDetail.ReadOnly
      ]
  object ListSequenceStoresPaginated
      extends Effect[
        ListSequenceStoresRequest,
        AwsError,
        zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly
      ]
  object GetRunTask
      extends Effect[
        GetRunTaskRequest,
        AwsError,
        zio.aws.omics.model.GetRunTaskResponse.ReadOnly
      ]
  object DeleteRunGroup extends Effect[DeleteRunGroupRequest, AwsError, Unit]
  object ListRuns
      extends Stream[
        ListRunsRequest,
        AwsError,
        zio.aws.omics.model.RunListItem.ReadOnly
      ]
  object ListRunsPaginated
      extends Effect[
        ListRunsRequest,
        AwsError,
        zio.aws.omics.model.ListRunsResponse.ReadOnly
      ]
  object CancelVariantImportJob
      extends Effect[
        CancelVariantImportJobRequest,
        AwsError,
        zio.aws.omics.model.CancelVariantImportJobResponse.ReadOnly
      ]
  object CreateMultipartReadSetUpload
      extends Effect[
        CreateMultipartReadSetUploadRequest,
        AwsError,
        zio.aws.omics.model.CreateMultipartReadSetUploadResponse.ReadOnly
      ]
  object ListReadSets
      extends Stream[
        ListReadSetsRequest,
        AwsError,
        zio.aws.omics.model.ReadSetListItem.ReadOnly
      ]
  object ListReadSetsPaginated
      extends Effect[
        ListReadSetsRequest,
        AwsError,
        zio.aws.omics.model.ListReadSetsResponse.ReadOnly
      ]
  object CreateReferenceStore
      extends Effect[
        CreateReferenceStoreRequest,
        AwsError,
        zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly
      ]
  object GetReferenceImportJob
      extends Effect[
        GetReferenceImportJobRequest,
        AwsError,
        zio.aws.omics.model.GetReferenceImportJobResponse.ReadOnly
      ]
  object UpdateWorkflow extends Effect[UpdateWorkflowRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.omics.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteReferenceStore
      extends Effect[
        DeleteReferenceStoreRequest,
        AwsError,
        zio.aws.omics.model.DeleteReferenceStoreResponse.ReadOnly
      ]
  object ListReferences
      extends Stream[
        ListReferencesRequest,
        AwsError,
        zio.aws.omics.model.ReferenceListItem.ReadOnly
      ]
  object ListReferencesPaginated
      extends Effect[
        ListReferencesRequest,
        AwsError,
        zio.aws.omics.model.ListReferencesResponse.ReadOnly
      ]
  object ListRunGroups
      extends Stream[
        ListRunGroupsRequest,
        AwsError,
        zio.aws.omics.model.RunGroupListItem.ReadOnly
      ]
  object ListRunGroupsPaginated
      extends Effect[
        ListRunGroupsRequest,
        AwsError,
        zio.aws.omics.model.ListRunGroupsResponse.ReadOnly
      ]
  object DeleteSequenceStore
      extends Effect[
        DeleteSequenceStoreRequest,
        AwsError,
        zio.aws.omics.model.DeleteSequenceStoreResponse.ReadOnly
      ]
  object GetWorkflow
      extends Effect[
        GetWorkflowRequest,
        AwsError,
        zio.aws.omics.model.GetWorkflowResponse.ReadOnly
      ]
  object ListReadSetImportJobs
      extends Stream[
        ListReadSetImportJobsRequest,
        AwsError,
        zio.aws.omics.model.ImportReadSetJobItem.ReadOnly
      ]
  object ListReadSetImportJobsPaginated
      extends Effect[
        ListReadSetImportJobsRequest,
        AwsError,
        zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.omics.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetAnnotationStore
      extends Effect[
        GetAnnotationStoreRequest,
        AwsError,
        zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly
      ]
  object DeleteRun extends Effect[DeleteRunRequest, AwsError, Unit]
  object ListReadSetActivationJobs
      extends Stream[
        ListReadSetActivationJobsRequest,
        AwsError,
        zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly
      ]
  object ListReadSetActivationJobsPaginated
      extends Effect[
        ListReadSetActivationJobsRequest,
        AwsError,
        zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.omics.model.TagResourceResponse.ReadOnly
      ]
  object GetReadSet
      extends Effect[GetReadSetRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.omics.model.GetReadSetResponse.ReadOnly,
        Byte
      ]]
  object CompleteMultipartReadSetUpload
      extends Effect[
        CompleteMultipartReadSetUploadRequest,
        AwsError,
        zio.aws.omics.model.CompleteMultipartReadSetUploadResponse.ReadOnly
      ]
  object ListWorkflows
      extends Stream[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.omics.model.WorkflowListItem.ReadOnly
      ]
  object ListWorkflowsPaginated
      extends Effect[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.omics.model.ListWorkflowsResponse.ReadOnly
      ]
  object CancelAnnotationImportJob
      extends Effect[
        CancelAnnotationImportJobRequest,
        AwsError,
        zio.aws.omics.model.CancelAnnotationImportJobResponse.ReadOnly
      ]
  object DeleteVariantStore
      extends Effect[
        DeleteVariantStoreRequest,
        AwsError,
        zio.aws.omics.model.DeleteVariantStoreResponse.ReadOnly
      ]
  object ListRunTasks
      extends Stream[
        ListRunTasksRequest,
        AwsError,
        zio.aws.omics.model.TaskListItem.ReadOnly
      ]
  object ListRunTasksPaginated
      extends Effect[
        ListRunTasksRequest,
        AwsError,
        zio.aws.omics.model.ListRunTasksResponse.ReadOnly
      ]
  object BatchDeleteReadSet
      extends Effect[
        BatchDeleteReadSetRequest,
        AwsError,
        zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly
      ]
  object CreateVariantStore
      extends Effect[
        CreateVariantStoreRequest,
        AwsError,
        zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly
      ]
  object StartRun
      extends Effect[
        StartRunRequest,
        AwsError,
        zio.aws.omics.model.StartRunResponse.ReadOnly
      ]
  object GetSequenceStore
      extends Effect[
        GetSequenceStoreRequest,
        AwsError,
        zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly
      ]
  object GetVariantImportJob
      extends Effect[
        GetVariantImportJobRequest,
        AwsError,
        zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly
      ]
  object UpdateVariantStore
      extends Effect[
        UpdateVariantStoreRequest,
        AwsError,
        zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly
      ]
  object GetReferenceMetadata
      extends Effect[
        GetReferenceMetadataRequest,
        AwsError,
        zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly
      ]
  object ListReadSetExportJobs
      extends Stream[
        ListReadSetExportJobsRequest,
        AwsError,
        zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly
      ]
  object ListReadSetExportJobsPaginated
      extends Effect[
        ListReadSetExportJobsRequest,
        AwsError,
        zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly
      ]
  object GetReadSetActivationJob
      extends Effect[
        GetReadSetActivationJobRequest,
        AwsError,
        zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly
      ]
  object DeleteWorkflow extends Effect[DeleteWorkflowRequest, AwsError, Unit]
  object GetReadSetMetadata
      extends Effect[
        GetReadSetMetadataRequest,
        AwsError,
        zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly
      ]
  object UpdateAnnotationStore
      extends Effect[
        UpdateAnnotationStoreRequest,
        AwsError,
        zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly
      ]
  object StartReadSetActivationJob
      extends Effect[
        StartReadSetActivationJobRequest,
        AwsError,
        zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly
      ]
  object CreateWorkflow
      extends Effect[
        CreateWorkflowRequest,
        AwsError,
        zio.aws.omics.model.CreateWorkflowResponse.ReadOnly
      ]
  object ListVariantImportJobs
      extends Stream[
        ListVariantImportJobsRequest,
        AwsError,
        zio.aws.omics.model.VariantImportJobItem.ReadOnly
      ]
  object ListVariantImportJobsPaginated
      extends Effect[
        ListVariantImportJobsRequest,
        AwsError,
        zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly
      ]
  object ListReadSetUploadParts
      extends Stream[
        ListReadSetUploadPartsRequest,
        AwsError,
        zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly
      ]
  object ListReadSetUploadPartsPaginated
      extends Effect[ListReadSetUploadPartsRequest, AwsError, ReadOnly]
  object CreateRunGroup
      extends Effect[
        CreateRunGroupRequest,
        AwsError,
        zio.aws.omics.model.CreateRunGroupResponse.ReadOnly
      ]
  object ListMultipartReadSetUploads
      extends Stream[
        ListMultipartReadSetUploadsRequest,
        AwsError,
        zio.aws.omics.model.MultipartReadSetUploadListItem.ReadOnly
      ]
  object ListMultipartReadSetUploadsPaginated
      extends Effect[
        ListMultipartReadSetUploadsRequest,
        AwsError,
        zio.aws.omics.model.ListMultipartReadSetUploadsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Omics] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Omics] { rts =>
        zio.ZIO.succeed {
          new Omics {
            val api: OmicsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Omics = this
            def createAnnotationStore(
                request: CreateAnnotationStoreRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.CreateAnnotationStoreResponse.ReadOnly
            ] = proxy(CreateAnnotationStore, request)
            def startReferenceImportJob(
                request: StartReferenceImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.StartReferenceImportJobResponse.ReadOnly
            ] = proxy(StartReferenceImportJob, request)
            def listAnnotationStores(
                request: ListAnnotationStoresRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.AnnotationStoreItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAnnotationStores, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAnnotationStoresPaginated(
                request: ListAnnotationStoresRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListAnnotationStoresResponse.ReadOnly
            ] = proxy(ListAnnotationStoresPaginated, request)
            def startAnnotationImportJob(
                request: StartAnnotationImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.StartAnnotationImportJobResponse.ReadOnly
            ] = proxy(StartAnnotationImportJob, request)
            def getAnnotationImportJob(
                request: GetAnnotationImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.GetAnnotationImportJobResponse.ReadOnly
            ] = proxy(GetAnnotationImportJob, request)
            def createSequenceStore(request: CreateSequenceStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.CreateSequenceStoreResponse.ReadOnly
            ] = proxy(CreateSequenceStore, request)
            def getReadSetImportJob(request: GetReadSetImportJobRequest): IO[
              AwsError,
              zio.aws.omics.model.GetReadSetImportJobResponse.ReadOnly
            ] = proxy(GetReadSetImportJob, request)
            def getReferenceStore(request: GetReferenceStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.GetReferenceStoreResponse.ReadOnly
            ] = proxy(GetReferenceStore, request)
            def updateRunGroup(
                request: UpdateRunGroupRequest
            ): IO[AwsError, Unit] = proxy(UpdateRunGroup, request)
            def listVariantStores(request: ListVariantStoresRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.VariantStoreItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVariantStores, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVariantStoresPaginated(
                request: ListVariantStoresRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListVariantStoresResponse.ReadOnly
            ] = proxy(ListVariantStoresPaginated, request)
            def listReferenceImportJobs(
                request: ListReferenceImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ImportReferenceJobItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReferenceImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReferenceImportJobsPaginated(
                request: ListReferenceImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListReferenceImportJobsResponse.ReadOnly
            ] = proxy(ListReferenceImportJobsPaginated, request)
            def getVariantStore(request: GetVariantStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.GetVariantStoreResponse.ReadOnly
            ] = proxy(GetVariantStore, request)
            def startReadSetImportJob(
                request: StartReadSetImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.StartReadSetImportJobResponse.ReadOnly
            ] = proxy(StartReadSetImportJob, request)
            def abortMultipartReadSetUpload(
                request: AbortMultipartReadSetUploadRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.AbortMultipartReadSetUploadResponse.ReadOnly
            ] = proxy(AbortMultipartReadSetUpload, request)
            def listReferenceStores(
                request: ListReferenceStoresRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ReferenceStoreDetail.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReferenceStores, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReferenceStoresPaginated(
                request: ListReferenceStoresRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListReferenceStoresResponse.ReadOnly
            ] = proxy(ListReferenceStoresPaginated, request)
            def getRun(
                request: GetRunRequest
            ): IO[AwsError, zio.aws.omics.model.GetRunResponse.ReadOnly] =
              proxy(GetRun, request)
            def deleteAnnotationStore(
                request: DeleteAnnotationStoreRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.DeleteAnnotationStoreResponse.ReadOnly
            ] = proxy(DeleteAnnotationStore, request)
            def deleteReference(request: DeleteReferenceRequest): IO[
              AwsError,
              zio.aws.omics.model.DeleteReferenceResponse.ReadOnly
            ] = proxy(DeleteReference, request)
            def startReadSetExportJob(
                request: StartReadSetExportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.StartReadSetExportJobResponse.ReadOnly
            ] = proxy(StartReadSetExportJob, request)
            def getReadSetExportJob(request: GetReadSetExportJobRequest): IO[
              AwsError,
              zio.aws.omics.model.GetReadSetExportJobResponse.ReadOnly
            ] = proxy(GetReadSetExportJob, request)
            def getReference(
                request: GetReferenceRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.omics.model.GetReferenceResponse.ReadOnly,
              Byte
            ]] = proxy(GetReference, request)
            def getRunGroup(
                request: GetRunGroupRequest
            ): IO[AwsError, zio.aws.omics.model.GetRunGroupResponse.ReadOnly] =
              proxy(GetRunGroup, request)
            def listAnnotationImportJobs(
                request: ListAnnotationImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.AnnotationImportJobItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAnnotationImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAnnotationImportJobsPaginated(
                request: ListAnnotationImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListAnnotationImportJobsResponse.ReadOnly
            ] = proxy(ListAnnotationImportJobsPaginated, request)
            def startVariantImportJob(
                request: StartVariantImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.StartVariantImportJobResponse.ReadOnly
            ] = proxy(StartVariantImportJob, request)
            def cancelRun(request: CancelRunRequest): IO[AwsError, Unit] =
              proxy(CancelRun, request)
            def uploadReadSetPart(
                request: UploadReadSetPartRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              zio.aws.omics.model.UploadReadSetPartResponse.ReadOnly
            ] = proxy(UploadReadSetPart, request, body)
            def listSequenceStores(request: ListSequenceStoresRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.SequenceStoreDetail.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSequenceStores, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSequenceStoresPaginated(
                request: ListSequenceStoresRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListSequenceStoresResponse.ReadOnly
            ] = proxy(ListSequenceStoresPaginated, request)
            def getRunTask(
                request: GetRunTaskRequest
            ): IO[AwsError, zio.aws.omics.model.GetRunTaskResponse.ReadOnly] =
              proxy(GetRunTask, request)
            def deleteRunGroup(
                request: DeleteRunGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteRunGroup, request)
            def listRuns(request: ListRunsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.RunListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRuns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRunsPaginated(
                request: ListRunsRequest
            ): IO[AwsError, zio.aws.omics.model.ListRunsResponse.ReadOnly] =
              proxy(ListRunsPaginated, request)
            def cancelVariantImportJob(
                request: CancelVariantImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.CancelVariantImportJobResponse.ReadOnly
            ] = proxy(CancelVariantImportJob, request)
            def createMultipartReadSetUpload(
                request: CreateMultipartReadSetUploadRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.CreateMultipartReadSetUploadResponse.ReadOnly
            ] = proxy(CreateMultipartReadSetUpload, request)
            def listReadSets(request: ListReadSetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ReadSetListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReadSets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReadSetsPaginated(
                request: ListReadSetsRequest
            ): IO[AwsError, zio.aws.omics.model.ListReadSetsResponse.ReadOnly] =
              proxy(ListReadSetsPaginated, request)
            def createReferenceStore(request: CreateReferenceStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.CreateReferenceStoreResponse.ReadOnly
            ] = proxy(CreateReferenceStore, request)
            def getReferenceImportJob(
                request: GetReferenceImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.GetReferenceImportJobResponse.ReadOnly
            ] = proxy(GetReferenceImportJob, request)
            def updateWorkflow(
                request: UpdateWorkflowRequest
            ): IO[AwsError, Unit] = proxy(UpdateWorkflow, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.omics.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteReferenceStore(request: DeleteReferenceStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.DeleteReferenceStoreResponse.ReadOnly
            ] = proxy(DeleteReferenceStore, request)
            def listReferences(request: ListReferencesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ReferenceListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReferences, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReferencesPaginated(request: ListReferencesRequest): IO[
              AwsError,
              zio.aws.omics.model.ListReferencesResponse.ReadOnly
            ] = proxy(ListReferencesPaginated, request)
            def listRunGroups(request: ListRunGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.RunGroupListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRunGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRunGroupsPaginated(request: ListRunGroupsRequest): IO[
              AwsError,
              zio.aws.omics.model.ListRunGroupsResponse.ReadOnly
            ] = proxy(ListRunGroupsPaginated, request)
            def deleteSequenceStore(request: DeleteSequenceStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.DeleteSequenceStoreResponse.ReadOnly
            ] = proxy(DeleteSequenceStore, request)
            def getWorkflow(
                request: GetWorkflowRequest
            ): IO[AwsError, zio.aws.omics.model.GetWorkflowResponse.ReadOnly] =
              proxy(GetWorkflow, request)
            def listReadSetImportJobs(
                request: ListReadSetImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ImportReadSetJobItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReadSetImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReadSetImportJobsPaginated(
                request: ListReadSetImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListReadSetImportJobsResponse.ReadOnly
            ] = proxy(ListReadSetImportJobsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.omics.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getAnnotationStore(request: GetAnnotationStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.GetAnnotationStoreResponse.ReadOnly
            ] = proxy(GetAnnotationStore, request)
            def deleteRun(request: DeleteRunRequest): IO[AwsError, Unit] =
              proxy(DeleteRun, request)
            def listReadSetActivationJobs(
                request: ListReadSetActivationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ActivateReadSetJobItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReadSetActivationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReadSetActivationJobsPaginated(
                request: ListReadSetActivationJobsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListReadSetActivationJobsResponse.ReadOnly
            ] = proxy(ListReadSetActivationJobsPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.omics.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def getReadSet(
                request: GetReadSetRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.omics.model.GetReadSetResponse.ReadOnly,
              Byte
            ]] = proxy(GetReadSet, request)
            def completeMultipartReadSetUpload(
                request: CompleteMultipartReadSetUploadRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.CompleteMultipartReadSetUploadResponse.ReadOnly
            ] = proxy(CompleteMultipartReadSetUpload, request)
            def listWorkflows(request: ListWorkflowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.WorkflowListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
              AwsError,
              zio.aws.omics.model.ListWorkflowsResponse.ReadOnly
            ] = proxy(ListWorkflowsPaginated, request)
            def cancelAnnotationImportJob(
                request: CancelAnnotationImportJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.CancelAnnotationImportJobResponse.ReadOnly
            ] = proxy(CancelAnnotationImportJob, request)
            def deleteVariantStore(request: DeleteVariantStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.DeleteVariantStoreResponse.ReadOnly
            ] = proxy(DeleteVariantStore, request)
            def listRunTasks(request: ListRunTasksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.TaskListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRunTasks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRunTasksPaginated(
                request: ListRunTasksRequest
            ): IO[AwsError, zio.aws.omics.model.ListRunTasksResponse.ReadOnly] =
              proxy(ListRunTasksPaginated, request)
            def batchDeleteReadSet(request: BatchDeleteReadSetRequest): IO[
              AwsError,
              zio.aws.omics.model.BatchDeleteReadSetResponse.ReadOnly
            ] = proxy(BatchDeleteReadSet, request)
            def createVariantStore(request: CreateVariantStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.CreateVariantStoreResponse.ReadOnly
            ] = proxy(CreateVariantStore, request)
            def startRun(
                request: StartRunRequest
            ): IO[AwsError, zio.aws.omics.model.StartRunResponse.ReadOnly] =
              proxy(StartRun, request)
            def getSequenceStore(request: GetSequenceStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.GetSequenceStoreResponse.ReadOnly
            ] = proxy(GetSequenceStore, request)
            def getVariantImportJob(request: GetVariantImportJobRequest): IO[
              AwsError,
              zio.aws.omics.model.GetVariantImportJobResponse.ReadOnly
            ] = proxy(GetVariantImportJob, request)
            def updateVariantStore(request: UpdateVariantStoreRequest): IO[
              AwsError,
              zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly
            ] = proxy(UpdateVariantStore, request)
            def getReferenceMetadata(request: GetReferenceMetadataRequest): IO[
              AwsError,
              zio.aws.omics.model.GetReferenceMetadataResponse.ReadOnly
            ] = proxy(GetReferenceMetadata, request)
            def listReadSetExportJobs(
                request: ListReadSetExportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ExportReadSetJobDetail.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReadSetExportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReadSetExportJobsPaginated(
                request: ListReadSetExportJobsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListReadSetExportJobsResponse.ReadOnly
            ] = proxy(ListReadSetExportJobsPaginated, request)
            def getReadSetActivationJob(
                request: GetReadSetActivationJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.GetReadSetActivationJobResponse.ReadOnly
            ] = proxy(GetReadSetActivationJob, request)
            def deleteWorkflow(
                request: DeleteWorkflowRequest
            ): IO[AwsError, Unit] = proxy(DeleteWorkflow, request)
            def getReadSetMetadata(request: GetReadSetMetadataRequest): IO[
              AwsError,
              zio.aws.omics.model.GetReadSetMetadataResponse.ReadOnly
            ] = proxy(GetReadSetMetadata, request)
            def updateAnnotationStore(
                request: UpdateAnnotationStoreRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.UpdateAnnotationStoreResponse.ReadOnly
            ] = proxy(UpdateAnnotationStore, request)
            def startReadSetActivationJob(
                request: StartReadSetActivationJobRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.StartReadSetActivationJobResponse.ReadOnly
            ] = proxy(StartReadSetActivationJob, request)
            def createWorkflow(request: CreateWorkflowRequest): IO[
              AwsError,
              zio.aws.omics.model.CreateWorkflowResponse.ReadOnly
            ] = proxy(CreateWorkflow, request)
            def listVariantImportJobs(
                request: ListVariantImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.VariantImportJobItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVariantImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVariantImportJobsPaginated(
                request: ListVariantImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListVariantImportJobsResponse.ReadOnly
            ] = proxy(ListVariantImportJobsPaginated, request)
            def listReadSetUploadParts(
                request: ListReadSetUploadPartsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.ReadSetUploadPartListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReadSetUploadParts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReadSetUploadPartsPaginated(
                request: ListReadSetUploadPartsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListReadSetUploadPartsPaginated, request)
            def createRunGroup(request: CreateRunGroupRequest): IO[
              AwsError,
              zio.aws.omics.model.CreateRunGroupResponse.ReadOnly
            ] = proxy(CreateRunGroup, request)
            def listMultipartReadSetUploads(
                request: ListMultipartReadSetUploadsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.omics.model.MultipartReadSetUploadListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMultipartReadSetUploads, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMultipartReadSetUploadsPaginated(
                request: ListMultipartReadSetUploadsRequest
            ): IO[
              AwsError,
              zio.aws.omics.model.ListMultipartReadSetUploadsResponse.ReadOnly
            ] = proxy(ListMultipartReadSetUploadsPaginated, request)
          }
        }
      }
    }
  }
}
