package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{UploadId, SequenceStoreId}
import scala.jdk.CollectionConverters._
final case class AbortMultipartReadSetUploadRequest(
    sequenceStoreId: SequenceStoreId,
    uploadId: UploadId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest = {
    import AbortMultipartReadSetUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.AbortMultipartReadSetUploadRequest.ReadOnly =
    zio.aws.omics.model.AbortMultipartReadSetUploadRequest.wrap(buildAwsValue())
}
object AbortMultipartReadSetUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.AbortMultipartReadSetUploadRequest =
      zio.aws.omics.model
        .AbortMultipartReadSetUploadRequest(sequenceStoreId, uploadId)
    def sequenceStoreId: SequenceStoreId
    def uploadId: UploadId
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest
  ) extends zio.aws.omics.model.AbortMultipartReadSetUploadRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val uploadId: UploadId =
      zio.aws.omics.model.primitives.UploadId(impl.uploadId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest
  ): zio.aws.omics.model.AbortMultipartReadSetUploadRequest.ReadOnly =
    new Wrapper(impl)
}
