package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait Accelerators {
  def unwrap: software.amazon.awssdk.services.omics.model.Accelerators
}
object Accelerators {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.Accelerators
  ): zio.aws.omics.model.Accelerators = value match {
    case software.amazon.awssdk.services.omics.model.Accelerators.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.Accelerators.GPU =>
      val r = GPU
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.Accelerators {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.Accelerators =
      software.amazon.awssdk.services.omics.model.Accelerators.UNKNOWN_TO_SDK_VERSION
  }
  case object GPU extends zio.aws.omics.model.Accelerators {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.Accelerators =
      software.amazon.awssdk.services.omics.model.Accelerators.GPU
  }
}
