package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{JobStatusMessage, ReadSetId}
import scala.jdk.CollectionConverters._
final case class ActivateReadSetSourceItem(
    readSetId: ReadSetId,
    status: zio.aws.omics.model.ReadSetActivationJobItemStatus,
    statusMessage: Optional[JobStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.ActivateReadSetSourceItem = {
    import ActivateReadSetSourceItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.ActivateReadSetSourceItem
      .builder()
      .readSetId(ReadSetId.unwrap(readSetId): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          JobStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly =
    zio.aws.omics.model.ActivateReadSetSourceItem.wrap(buildAwsValue())
}
object ActivateReadSetSourceItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.ActivateReadSetSourceItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.ActivateReadSetSourceItem =
      zio.aws.omics.model.ActivateReadSetSourceItem(
        readSetId,
        status,
        statusMessage.map(value => value)
      )
    def readSetId: ReadSetId
    def status: zio.aws.omics.model.ReadSetActivationJobItemStatus
    def statusMessage: Optional[JobStatusMessage]
    def getReadSetId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(readSetId)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.omics.model.ReadSetActivationJobItemStatus
    ] = ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, JobStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.ActivateReadSetSourceItem
  ) extends zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly {
    override val readSetId: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.readSetId())
    override val status: zio.aws.omics.model.ReadSetActivationJobItemStatus =
      zio.aws.omics.model.ReadSetActivationJobItemStatus.wrap(impl.status())
    override val statusMessage: Optional[JobStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value => zio.aws.omics.model.primitives.JobStatusMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.ActivateReadSetSourceItem
  ): zio.aws.omics.model.ActivateReadSetSourceItem.ReadOnly = new Wrapper(impl)
}
