package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class AnnotationImportItemDetail(
    source: S3Uri,
    jobStatus: zio.aws.omics.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail = {
    import AnnotationImportItemDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
      .builder()
      .source(S3Uri.unwrap(source): java.lang.String)
      .jobStatus(jobStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly =
    zio.aws.omics.model.AnnotationImportItemDetail.wrap(buildAwsValue())
}
object AnnotationImportItemDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.AnnotationImportItemDetail =
      zio.aws.omics.model.AnnotationImportItemDetail(source, jobStatus)
    def source: S3Uri
    def jobStatus: zio.aws.omics.model.JobStatus
    def getSource: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(source)
    def getJobStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
  ) extends zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly {
    override val source: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.source())
    override val jobStatus: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.jobStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail
  ): zio.aws.omics.model.AnnotationImportItemDetail.ReadOnly = new Wrapper(impl)
}
