package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class AnnotationImportItemSource(source: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.AnnotationImportItemSource = {
    import AnnotationImportItemSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.AnnotationImportItemSource
      .builder()
      .source(S3Uri.unwrap(source): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.AnnotationImportItemSource.ReadOnly =
    zio.aws.omics.model.AnnotationImportItemSource.wrap(buildAwsValue())
}
object AnnotationImportItemSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.AnnotationImportItemSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.AnnotationImportItemSource =
      zio.aws.omics.model.AnnotationImportItemSource(source)
    def source: S3Uri
    def getSource: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.AnnotationImportItemSource
  ) extends zio.aws.omics.model.AnnotationImportItemSource.ReadOnly {
    override val source: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.AnnotationImportItemSource
  ): zio.aws.omics.model.AnnotationImportItemSource.ReadOnly = new Wrapper(impl)
}
