package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  Arn,
  ResourceId,
  StatusMessage,
  StoreDescription
}
import scala.jdk.CollectionConverters._
final case class AnnotationStoreItem(
    id: ResourceId,
    reference: zio.aws.omics.model.ReferenceItem,
    status: zio.aws.omics.model.StoreStatus,
    storeArn: Arn,
    name: String,
    storeFormat: zio.aws.omics.model.StoreFormat,
    description: StoreDescription,
    sseConfig: zio.aws.omics.model.SseConfig,
    creationTime: CreationTime,
    updateTime: UpdateTime,
    statusMessage: StatusMessage,
    storeSizeBytes: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.AnnotationStoreItem = {
    import AnnotationStoreItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.AnnotationStoreItem
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .reference(reference.buildAwsValue())
      .status(status.unwrap)
      .storeArn(Arn.unwrap(storeArn): java.lang.String)
      .name(name: java.lang.String)
      .storeFormat(storeFormat.unwrap)
      .description(StoreDescription.unwrap(description): java.lang.String)
      .sseConfig(sseConfig.buildAwsValue())
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .statusMessage(StatusMessage.unwrap(statusMessage): java.lang.String)
      .storeSizeBytes(storeSizeBytes: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.AnnotationStoreItem.ReadOnly =
    zio.aws.omics.model.AnnotationStoreItem.wrap(buildAwsValue())
}
object AnnotationStoreItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.AnnotationStoreItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.AnnotationStoreItem =
      zio.aws.omics.model.AnnotationStoreItem(
        id,
        reference.asEditable,
        status,
        storeArn,
        name,
        storeFormat,
        description,
        sseConfig.asEditable,
        creationTime,
        updateTime,
        statusMessage,
        storeSizeBytes
      )
    def id: ResourceId
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def status: zio.aws.omics.model.StoreStatus
    def storeArn: Arn
    def name: String
    def storeFormat: zio.aws.omics.model.StoreFormat
    def description: StoreDescription
    def sseConfig: zio.aws.omics.model.SseConfig.ReadOnly
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def statusMessage: StatusMessage
    def storeSizeBytes: Long
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getStoreArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(storeArn)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStoreFormat: ZIO[Any, Nothing, zio.aws.omics.model.StoreFormat] =
      ZIO.succeed(storeFormat)
    def getDescription: ZIO[Any, Nothing, StoreDescription] =
      ZIO.succeed(description)
    def getSseConfig
        : ZIO[Any, Nothing, zio.aws.omics.model.SseConfig.ReadOnly] =
      ZIO.succeed(sseConfig)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getStatusMessage: ZIO[Any, Nothing, StatusMessage] =
      ZIO.succeed(statusMessage)
    def getStoreSizeBytes: ZIO[Any, Nothing, Long] = ZIO.succeed(storeSizeBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.AnnotationStoreItem
  ) extends zio.aws.omics.model.AnnotationStoreItem.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val storeArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.storeArn())
    override val name: String = impl.name(): String
    override val storeFormat: zio.aws.omics.model.StoreFormat =
      zio.aws.omics.model.StoreFormat.wrap(impl.storeFormat())
    override val description: StoreDescription =
      zio.aws.omics.model.primitives.StoreDescription(impl.description())
    override val sseConfig: zio.aws.omics.model.SseConfig.ReadOnly =
      zio.aws.omics.model.SseConfig.wrap(impl.sseConfig())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
    override val statusMessage: StatusMessage =
      zio.aws.omics.model.primitives.StatusMessage(impl.statusMessage())
    override val storeSizeBytes: Long = impl.storeSizeBytes(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.AnnotationStoreItem
  ): zio.aws.omics.model.AnnotationStoreItem.ReadOnly = new Wrapper(impl)
}
