package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait AnnotationType {
  def unwrap: software.amazon.awssdk.services.omics.model.AnnotationType
}
object AnnotationType {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.AnnotationType
  ): zio.aws.omics.model.AnnotationType = value match {
    case software.amazon.awssdk.services.omics.model.AnnotationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.GENERIC =>
      val r = GENERIC
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.CHR_POS =>
      val r = CHR_POS
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.CHR_POS_REF_ALT =>
      val r = CHR_POS_REF_ALT
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_ONE_BASE =>
      val r = CHR_START_END_ONE_BASE
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_REF_ALT_ONE_BASE =>
      val r = CHR_START_END_REF_ALT_ONE_BASE
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_ZERO_BASE =>
      val r = CHR_START_END_ZERO_BASE
      r
    case software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_REF_ALT_ZERO_BASE =>
      val r = CHR_START_END_REF_ALT_ZERO_BASE
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.UNKNOWN_TO_SDK_VERSION
  }
  case object GENERIC extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.GENERIC
  }
  case object CHR_POS extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.CHR_POS
  }
  case object CHR_POS_REF_ALT extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.CHR_POS_REF_ALT
  }
  case object CHR_START_END_ONE_BASE
      extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_ONE_BASE
  }
  case object CHR_START_END_REF_ALT_ONE_BASE
      extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_REF_ALT_ONE_BASE
  }
  case object CHR_START_END_ZERO_BASE
      extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_ZERO_BASE
  }
  case object CHR_START_END_REF_ALT_ZERO_BASE
      extends zio.aws.omics.model.AnnotationType {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.AnnotationType =
      software.amazon.awssdk.services.omics.model.AnnotationType.CHR_START_END_REF_ALT_ZERO_BASE
  }
}
