package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.RunId
import scala.jdk.CollectionConverters._
final case class CancelRunRequest(id: RunId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CancelRunRequest = {
    import CancelRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CancelRunRequest
      .builder()
      .id(RunId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CancelRunRequest.ReadOnly =
    zio.aws.omics.model.CancelRunRequest.wrap(buildAwsValue())
}
object CancelRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CancelRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CancelRunRequest =
      zio.aws.omics.model.CancelRunRequest(id)
    def id: RunId
    def getId: ZIO[Any, Nothing, RunId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CancelRunRequest
  ) extends zio.aws.omics.model.CancelRunRequest.ReadOnly {
    override val id: RunId = zio.aws.omics.model.primitives.RunId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CancelRunRequest
  ): zio.aws.omics.model.CancelRunRequest.ReadOnly = new Wrapper(impl)
}
