package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class CancelVariantImportJobRequest(jobId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest = {
    import CancelVariantImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest
      .builder()
      .jobId(ResourceId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.CancelVariantImportJobRequest.ReadOnly =
    zio.aws.omics.model.CancelVariantImportJobRequest.wrap(buildAwsValue())
}
object CancelVariantImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CancelVariantImportJobRequest =
      zio.aws.omics.model.CancelVariantImportJobRequest(jobId)
    def jobId: ResourceId
    def getJobId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest
  ) extends zio.aws.omics.model.CancelVariantImportJobRequest.ReadOnly {
    override val jobId: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest
  ): zio.aws.omics.model.CancelVariantImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
