package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{UploadId, SequenceStoreId}
import scala.jdk.CollectionConverters._
final case class CompleteMultipartReadSetUploadRequest(
    sequenceStoreId: SequenceStoreId,
    uploadId: UploadId,
    parts: Iterable[zio.aws.omics.model.CompleteReadSetUploadPartListItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest = {
    import CompleteMultipartReadSetUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .parts(parts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.CompleteMultipartReadSetUploadRequest.ReadOnly =
    zio.aws.omics.model.CompleteMultipartReadSetUploadRequest
      .wrap(buildAwsValue())
}
object CompleteMultipartReadSetUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CompleteMultipartReadSetUploadRequest =
      zio.aws.omics.model.CompleteMultipartReadSetUploadRequest(
        sequenceStoreId,
        uploadId,
        parts.map { item =>
          item.asEditable
        }
      )
    def sequenceStoreId: SequenceStoreId
    def uploadId: UploadId
    def parts
        : List[zio.aws.omics.model.CompleteReadSetUploadPartListItem.ReadOnly]
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
    def getParts: ZIO[Any, Nothing, List[
      zio.aws.omics.model.CompleteReadSetUploadPartListItem.ReadOnly
    ]] = ZIO.succeed(parts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest
  ) extends zio.aws.omics.model.CompleteMultipartReadSetUploadRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val uploadId: UploadId =
      zio.aws.omics.model.primitives.UploadId(impl.uploadId())
    override val parts
        : List[zio.aws.omics.model.CompleteReadSetUploadPartListItem.ReadOnly] =
      impl
        .parts()
        .asScala
        .map { item =>
          zio.aws.omics.model.CompleteReadSetUploadPartListItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest
  ): zio.aws.omics.model.CompleteMultipartReadSetUploadRequest.ReadOnly =
    new Wrapper(impl)
}
