package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.ReadSetId
import scala.jdk.CollectionConverters._
final case class CompleteMultipartReadSetUploadResponse(readSetId: ReadSetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse = {
    import CompleteMultipartReadSetUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse
      .builder()
      .readSetId(ReadSetId.unwrap(readSetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.CompleteMultipartReadSetUploadResponse.ReadOnly =
    zio.aws.omics.model.CompleteMultipartReadSetUploadResponse
      .wrap(buildAwsValue())
}
object CompleteMultipartReadSetUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CompleteMultipartReadSetUploadResponse =
      zio.aws.omics.model.CompleteMultipartReadSetUploadResponse(readSetId)
    def readSetId: ReadSetId
    def getReadSetId: ZIO[Any, Nothing, ReadSetId] = ZIO.succeed(readSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse
  ) extends zio.aws.omics.model.CompleteMultipartReadSetUploadResponse.ReadOnly {
    override val readSetId: ReadSetId =
      zio.aws.omics.model.primitives.ReadSetId(impl.readSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse
  ): zio.aws.omics.model.CompleteMultipartReadSetUploadResponse.ReadOnly =
    new Wrapper(impl)
}
