package zio.aws.omics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.CompleteReadSetUploadPartListItemPartNumberInteger
import scala.jdk.CollectionConverters._
final case class CompleteReadSetUploadPartListItem(
    partNumber: CompleteReadSetUploadPartListItemPartNumberInteger,
    partSource: zio.aws.omics.model.ReadSetPartSource,
    checksum: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem = {
    import CompleteReadSetUploadPartListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem
      .builder()
      .partNumber(
        CompleteReadSetUploadPartListItemPartNumberInteger.unwrap(
          partNumber
        ): Integer
      )
      .partSource(partSource.unwrap)
      .checksum(checksum: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.omics.model.CompleteReadSetUploadPartListItem.ReadOnly =
    zio.aws.omics.model.CompleteReadSetUploadPartListItem.wrap(buildAwsValue())
}
object CompleteReadSetUploadPartListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.CompleteReadSetUploadPartListItem =
      zio.aws.omics.model
        .CompleteReadSetUploadPartListItem(partNumber, partSource, checksum)
    def partNumber: CompleteReadSetUploadPartListItemPartNumberInteger
    def partSource: zio.aws.omics.model.ReadSetPartSource
    def checksum: String
    def getPartNumber: ZIO[
      Any,
      Nothing,
      CompleteReadSetUploadPartListItemPartNumberInteger
    ] = ZIO.succeed(partNumber)
    def getPartSource
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetPartSource] =
      ZIO.succeed(partSource)
    def getChecksum: ZIO[Any, Nothing, String] = ZIO.succeed(checksum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem
  ) extends zio.aws.omics.model.CompleteReadSetUploadPartListItem.ReadOnly {
    override val partNumber
        : CompleteReadSetUploadPartListItemPartNumberInteger =
      zio.aws.omics.model.primitives
        .CompleteReadSetUploadPartListItemPartNumberInteger(impl.partNumber())
    override val partSource: zio.aws.omics.model.ReadSetPartSource =
      zio.aws.omics.model.ReadSetPartSource.wrap(impl.partSource())
    override val checksum: String = impl.checksum(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem
  ): zio.aws.omics.model.CompleteReadSetUploadPartListItem.ReadOnly =
    new Wrapper(impl)
}
